/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.connection.Connection;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.txn.RecoverAllTransactionsRequest;
import com.hazelcast.client.txn.RecoverTransactionRequest;
import com.hazelcast.client.txn.TransactionContextProxy;
import com.hazelcast.client.txn.TransactionProxy;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.transaction.TransactionalTaskContext;
import com.hazelcast.transaction.impl.SerializableXID;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;

public class ClientTransactionManager {
    static final int CONNECTION_TRY_COUNT = 5;
    final HazelcastClient client;
    final ConcurrentMap<SerializableXID, TransactionProxy> managedTransactions = new ConcurrentHashMap<SerializableXID, TransactionProxy>();
    final ConcurrentMap<SerializableXID, Connection> recoveredTransactions = new ConcurrentHashMap<SerializableXID, Connection>();

    public ClientTransactionManager(HazelcastClient client) {
        this.client = client;
    }

    public HazelcastClient getClient() {
        return this.client;
    }

    public TransactionContext newTransactionContext() {
        return this.newTransactionContext(TransactionOptions.getDefault());
    }

    public TransactionContext newTransactionContext(TransactionOptions options) {
        return new TransactionContextProxy(this, options);
    }

    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.executeTransaction(TransactionOptions.getDefault(), task);
    }

    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        TransactionContext context = this.newTransactionContext(options);
        context.beginTransaction();
        try {
            Object value = task.execute((TransactionalTaskContext)context);
            context.commitTransaction();
            return (T)value;
        }
        catch (Throwable e) {
            context.rollbackTransaction();
            if (e instanceof TransactionException) {
                throw (TransactionException)e;
            }
            if (e.getCause() instanceof TransactionException) {
                throw (TransactionException)e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionException(e);
        }
    }

    public void addManagedTransaction(Xid xid, TransactionProxy transaction) {
        SerializableXID sXid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        transaction.setXid(sXid);
        this.managedTransactions.put(sXid, transaction);
    }

    public TransactionProxy getManagedTransaction(Xid xid) {
        SerializableXID sXid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        return (TransactionProxy)this.managedTransactions.get(sXid);
    }

    public void removeManagedTransaction(Xid xid) {
        SerializableXID sXid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        this.managedTransactions.remove(sXid);
    }

    Connection connect() {
        Connection conn = null;
        for (int i = 0; i < 5; ++i) {
            try {
                conn = this.client.getConnectionManager().getRandomConnection();
            }
            catch (IOException e) {
                continue;
            }
            if (conn != null) break;
        }
        return conn;
    }

    public Xid[] recover() {
        SerializationService serializationService = this.client.getSerializationService();
        ClientClusterServiceImpl clusterService = (ClientClusterServiceImpl)this.client.getClientClusterService();
        Xid[] empty = new Xid[]{};
        try {
            Connection connection = this.connect();
            if (connection == null) {
                return empty;
            }
            RecoverAllTransactionsRequest request = new RecoverAllTransactionsRequest();
            SerializableCollection collectionWrapper = (SerializableCollection)clusterService.sendAndReceiveFixedConnection(connection, request);
            ConnectionWrapper connectionWrapper = new ConnectionWrapper(connection, collectionWrapper.size());
            for (Data data : collectionWrapper) {
                SerializableXID xid = (SerializableXID)serializationService.toObject(data);
                this.recoveredTransactions.put(xid, connectionWrapper);
            }
            Set xidSet = this.recoveredTransactions.keySet();
            return xidSet.toArray(new Xid[xidSet.size()]);
        }
        catch (Exception e) {
            ExceptionUtil.rethrow((Throwable)e);
            return empty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recover(Xid xid, boolean commit) {
        SerializableXID sXid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        Connection connection = (Connection)this.recoveredTransactions.remove(sXid);
        if (connection == null) {
            return false;
        }
        ClientClusterServiceImpl clusterService = (ClientClusterServiceImpl)this.client.getClientClusterService();
        RecoverTransactionRequest request = new RecoverTransactionRequest(sXid, commit);
        try {
            clusterService.sendAndReceiveFixedConnection(connection, request);
        }
        catch (Exception e) {
            ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            try {
                connection.release();
            }
            catch (IOException e) {
                Logger.getLogger(ClientTransactionManager.class).severe("Error during connection release", (Throwable)e);
            }
        }
        return true;
    }

    class ConnectionWrapper
    implements Connection {
        final Connection inner;
        final AtomicInteger counter;

        ConnectionWrapper(Connection inner, int size) {
            this.inner = inner;
            this.counter = new AtomicInteger(size);
        }

        @Override
        public Address getEndpoint() {
            return this.inner.getEndpoint();
        }

        @Override
        public boolean write(Data data) throws IOException {
            return this.inner.write(data);
        }

        @Override
        public Data read() throws IOException {
            return this.inner.read();
        }

        @Override
        public int getId() {
            return this.inner.getId();
        }

        @Override
        public long getLastReadTime() {
            return this.inner.getLastReadTime();
        }

        @Override
        public void release() throws IOException {
            if (this.counter.decrementAndGet() == 0) {
                this.inner.release();
            }
        }

        @Override
        public void close() throws IOException {
            this.inner.close();
        }

        @Override
        public void setEndpoint(Address address) {
            this.inner.setEndpoint(address);
        }
    }
}

