/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.proxy.ClientAtomicLongProxy;
import com.hazelcast.client.proxy.ClientCountDownLatchProxy;
import com.hazelcast.client.proxy.ClientExecutorServiceProxy;
import com.hazelcast.client.proxy.ClientIdGeneratorProxy;
import com.hazelcast.client.proxy.ClientListProxy;
import com.hazelcast.client.proxy.ClientLockProxy;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.proxy.ClientMultiMapProxy;
import com.hazelcast.client.proxy.ClientQueueProxy;
import com.hazelcast.client.proxy.ClientSemaphoreProxy;
import com.hazelcast.client.proxy.ClientSetProxy;
import com.hazelcast.client.proxy.ClientTopicProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ClientProxyFactory;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionProxyType;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ProxyManager {
    private final HazelcastClient client;
    private final ConcurrentMap<String, ClientProxyFactory> proxyFactories = new ConcurrentHashMap<String, ClientProxyFactory>();
    private final ConcurrentMap<ObjectNamespace, ClientProxy> proxies = new ConcurrentHashMap<ObjectNamespace, ClientProxy>();
    private final ConcurrentMap<String, DistributedObjectListener> listeners = new ConcurrentHashMap<String, DistributedObjectListener>();

    public ProxyManager(HazelcastClient client) {
        this.client = client;
        Collection<EventListener> listeners = client.getClientConfig().getListeners();
        if (listeners != null && !listeners.isEmpty()) {
            for (EventListener listener : listeners) {
                if (!(listener instanceof DistributedObjectListener)) continue;
                this.addDistributedObjectListener((DistributedObjectListener)listener);
            }
        }
    }

    public void init(ProxyFactoryConfig config) {
        this.register("hz:impl:mapService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(Object id) {
                return new ClientMapProxy("hz:impl:mapService", String.valueOf(id));
            }
        });
        this.register("hz:impl:queueService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(Object id) {
                return new ClientQueueProxy("hz:impl:queueService", String.valueOf(id));
            }
        });
        this.register("hz:impl:collectionService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(Object id) {
                CollectionProxyId proxyId = (CollectionProxyId)id;
                CollectionProxyType type = proxyId.getType();
                switch (type) {
                    case MULTI_MAP: {
                        return new ClientMultiMapProxy("hz:impl:collectionService", proxyId);
                    }
                    case LIST: {
                        return new ClientListProxy("hz:impl:collectionService", proxyId);
                    }
                    case SET: {
                        return new ClientSetProxy("hz:impl:collectionService", proxyId);
                    }
                    case QUEUE: {
                        return null;
                    }
                }
                return null;
            }
        });
        this.register("hz:impl:semaphoreService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(Object id) {
                return new ClientSemaphoreProxy("hz:impl:semaphoreService", String.valueOf(id));
            }
        });
        this.register("hz:impl:topicService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(Object id) {
                return new ClientTopicProxy("hz:impl:topicService", String.valueOf(id));
            }
        });
        this.register("hz:impl:atomicLongService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(Object id) {
                return new ClientAtomicLongProxy("hz:impl:atomicLongService", String.valueOf(id));
            }
        });
        this.register("hz:impl:executorService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(Object id) {
                return new ClientExecutorServiceProxy("hz:impl:executorService", String.valueOf(id));
            }
        });
        this.register("hz:impl:lockService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(Object id) {
                return new ClientLockProxy("hz:impl:executorService", id);
            }
        });
        this.register("hz:impl:idGeneratorService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(Object id) {
                String name = String.valueOf(id);
                IAtomicLong atomicLong = ProxyManager.this.client.getAtomicLong("hz:atomic:idGenerator:" + name);
                return new ClientIdGeneratorProxy("hz:impl:executorService", name, atomicLong);
            }
        });
        this.register("hz:impl:countDownLatchService", new ClientProxyFactory(){

            @Override
            public ClientProxy create(Object id) {
                return new ClientCountDownLatchProxy("hz:impl:countDownLatchService", String.valueOf(id));
            }
        });
        for (Map.Entry<String, ClientProxyFactory> entry : config.getFactories().entrySet()) {
            this.register(entry.getKey(), entry.getValue());
        }
    }

    public void register(String serviceName, ClientProxyFactory factory) {
        if (this.proxyFactories.putIfAbsent(serviceName, factory) != null) {
            throw new IllegalArgumentException("Factory for service: " + serviceName + " is already registered!");
        }
    }

    public ClientProxy getProxy(String service, Object id) {
        DefaultObjectNamespace ns = new DefaultObjectNamespace(service, id);
        ClientProxy proxy = (ClientProxy)this.proxies.get(ns);
        if (proxy != null) {
            return proxy;
        }
        ClientProxyFactory factory = (ClientProxyFactory)this.proxyFactories.get(service);
        if (factory == null) {
            throw new IllegalArgumentException("No factory registered for service: " + service);
        }
        ClientProxy clientProxy = factory.create(id);
        this.initialize(clientProxy);
        ClientProxy current = this.proxies.putIfAbsent((ObjectNamespace)ns, clientProxy);
        if (current != null) {
            return current;
        }
        this.triggerListeners(clientProxy, false);
        return clientProxy;
    }

    public ClientProxy removeProxy(String service, Object id) {
        DefaultObjectNamespace ns = new DefaultObjectNamespace(service, id);
        ClientProxy clientProxy = (ClientProxy)this.proxies.remove(ns);
        if (clientProxy != null) {
            this.triggerListeners(clientProxy, true);
        }
        return clientProxy;
    }

    private void initialize(ClientProxy clientProxy) {
        clientProxy.setContext(new ClientContext(this.client.getSerializationService(), this.client.getClientClusterService(), this.client.getClientPartitionService(), this.client.getInvocationService(), this.client.getClientExecutionService(), this, this.client.getClientConfig()));
    }

    public Collection<? extends DistributedObject> getDistributedObjects() {
        return Collections.unmodifiableCollection(this.proxies.values());
    }

    public void destroy() {
        this.proxies.clear();
        this.listeners.clear();
    }

    private void triggerListeners(final ClientProxy proxy, final boolean removed) {
        this.client.getClientExecutionService().execute(new Runnable(){

            @Override
            public void run() {
                DistributedObjectEvent event = removed ? new DistributedObjectEvent(DistributedObjectEvent.EventType.DESTROYED, proxy.getServiceName(), (DistributedObject)proxy) : new DistributedObjectEvent(DistributedObjectEvent.EventType.CREATED, proxy.getServiceName(), (DistributedObject)proxy);
                for (DistributedObjectListener listener : ProxyManager.this.listeners.values()) {
                    if (removed) {
                        listener.distributedObjectDestroyed(event);
                        continue;
                    }
                    listener.distributedObjectCreated(event);
                }
            }
        });
    }

    public String addDistributedObjectListener(DistributedObjectListener listener) {
        String id = UUID.randomUUID().toString();
        this.listeners.put(id, listener);
        return id;
    }

    public boolean removeDistributedObjectListener(String id) {
        return this.listeners.remove(id) != null;
    }
}

