/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.txn.TransactionContextProxy;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;

abstract class ClientTxnProxy {
    final Object id;
    final TransactionContextProxy proxy;

    ClientTxnProxy(Object id, TransactionContextProxy proxy) {
        this.id = id;
        this.proxy = proxy;
    }

    final <T> T invoke(Object request) {
        ClientClusterServiceImpl clusterService = (ClientClusterServiceImpl)this.proxy.getClient().getClientClusterService();
        try {
            return clusterService.sendAndReceiveFixedConnection(this.proxy.getConnection(), request);
        }
        catch (IOException e) {
            ExceptionUtil.rethrow((Throwable)new HazelcastException((Throwable)e));
            return null;
        }
    }

    abstract void onDestroy();

    public final void destroy() {
        this.onDestroy();
    }

    public Object getId() {
        return this.id;
    }

    Data toData(Object obj) {
        return this.proxy.getClient().getSerializationService().toData(obj);
    }

    Object toObject(Data data) {
        return this.proxy.getClient().getSerializationService().toObject(data);
    }
}

