/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hazelcast.client.MapClientProxy;
import com.hazelcast.client.NearCache;
import com.hazelcast.config.NearCacheConfig;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuavaNearCacheImpl<K, V>
implements NearCache<K, V> {
    LoadingCache<K, V> cache;
    private MapClientProxy<K, V> map;

    public GuavaNearCacheImpl(NearCacheConfig nc, final MapClientProxy<K, V> map) {
        this.map = map;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize((long)nc.getMaxSize());
        if (nc.getTimeToLiveSeconds() > 0) {
            cacheBuilder.expireAfterWrite((long)nc.getTimeToLiveSeconds(), TimeUnit.SECONDS);
        }
        if (nc.getMaxIdleSeconds() > 0) {
            cacheBuilder.expireAfterAccess((long)nc.getMaxIdleSeconds(), TimeUnit.SECONDS);
        }
        this.cache = cacheBuilder.build(new CacheLoader(){

            public Object load(Object o) throws Exception {
                try {
                    return map.get0(o);
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }
        });
    }

    @Override
    public void invalidate(K key) {
        this.cache.invalidate(key);
    }

    @Override
    public V get(K key) {
        try {
            return (V)this.cache.get(key);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            return this.map.get0(key);
        }
    }
}

