/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.Serializer;
import com.hazelcast.core.MessageListener;
import com.hazelcast.impl.ClusterOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageListenerManager {
    private final ConcurrentHashMap<String, List<MessageListener>> messageListeners = new ConcurrentHashMap();

    public void registerListener(String name, MessageListener messageListener) {
        CopyOnWriteArrayList<MessageListener> newListenersList = new CopyOnWriteArrayList<MessageListener>();
        CopyOnWriteArrayList<MessageListener> listeners = this.messageListeners.putIfAbsent(name, newListenersList);
        if (listeners == null) {
            listeners = newListenersList;
        }
        listeners.add(messageListener);
    }

    public void removeListener(String name, MessageListener messageListener) {
        if (!this.messageListeners.containsKey(name)) {
            return;
        }
        this.messageListeners.get(name).remove(messageListener);
        if (this.messageListeners.get(name).isEmpty()) {
            this.messageListeners.remove(name);
        }
    }

    public boolean noListenerRegistered(String name) {
        if (!this.messageListeners.containsKey(name)) {
            return true;
        }
        return this.messageListeners.get(name).isEmpty();
    }

    public void notifyMessageListeners(Packet packet) {
        List<MessageListener> list = this.messageListeners.get(packet.getName());
        if (list != null) {
            for (MessageListener messageListener : list) {
                Object message = Serializer.toObject(packet.getKey());
                messageListener.onMessage(message);
            }
        }
    }

    public Call createNewAddListenerCall(ProxyHelper proxyHelper) {
        Packet request = proxyHelper.createRequestPacket(ClusterOperation.ADD_LISTENER, null, null);
        return proxyHelper.createCall(request);
    }

    public Collection<Call> calls(HazelcastClient client) {
        ArrayList<Call> calls = new ArrayList<Call>();
        for (String name : this.messageListeners.keySet()) {
            ProxyHelper proxyHelper = new ProxyHelper(name, client);
            calls.add(this.createNewAddListenerCall(proxyHelper));
        }
        return calls;
    }
}

