/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientBinder;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.client.cluster.Bind;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;

public class DefaultClientBinder
implements ClientBinder {
    private HazelcastClient client;
    private final ILogger logger = Logger.getLogger((String)this.getClass().getName());

    public DefaultClientBinder(HazelcastClient client) {
        this.client = client;
    }

    public void bind(Connection connection) throws IOException {
        this.logger.log(Level.FINEST, connection + " -> " + connection.getAddress().getHostName() + ":" + connection.getSocket().getLocalPort());
        this.auth(connection);
        Bind b = null;
        try {
            b = new Bind(new Address(connection.getAddress().getHostName(), connection.getSocket().getLocalPort()));
        }
        catch (UnknownHostException e) {
            this.logger.log(Level.WARNING, e.getMessage() + " while creating the bind package.");
            throw e;
        }
        Packet bind = new Packet();
        bind.set("remotelyProcess", ClusterOperation.REMOTELY_PROCESS, Serializer.toByte(null), Serializer.toByte(b));
        this.write(connection, bind);
    }

    void auth(Connection connection) throws IOException {
        Packet auth = new Packet();
        GroupConfig groupConfig = this.client.groupConfig();
        auth.set("", ClusterOperation.CLIENT_AUTHENTICATE, Serializer.toByte(groupConfig.getName()), Serializer.toByte(groupConfig.getPassword()));
        Packet packet = this.writeAndRead(connection, auth);
        Object response = Serializer.toObject(packet.getValue());
        this.logger.log(Level.FINEST, "auth responce:" + response);
        if (response instanceof Exception) {
            throw new RuntimeException((Exception)response);
        }
        if (!Boolean.TRUE.equals(response)) {
            throw new AuthenticationException("Client [" + connection + "] has failed authentication");
        }
    }

    Packet writeAndRead(Connection connection, Packet packet) throws IOException {
        this.write(connection, packet);
        return this.client.getInRunnable().reader.readPacket(connection);
    }

    void write(Connection connection, Packet packet) throws IOException {
        this.client.getOutRunnable().write(connection, packet);
    }
}

