/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.OutRunnable;
import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.client.impl.CollectionWrapper;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.query.Predicate;
import java.io.Serializable;
import java.util.Collection;
import java.util.EventListener;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyHelper {
    OutRunnable out;
    protected String name = "";
    protected final HazelcastClient client;

    public ProxyHelper(String name, HazelcastClient client) {
        if (name != null) {
            this.name = name;
        }
        this.client = client;
    }

    public void setOutRunnable(OutRunnable out) {
        this.out = out;
    }

    public String getName() {
        return this.name.substring(2);
    }

    protected Packet callAndGetResult(Packet request) {
        Call c = this.createCall(request);
        return this.doCall(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Packet doCall(Call c) {
        Call call = c;
        synchronized (call) {
            try {
                this.out.enQueue(c);
                c.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Exception e = c.getException();
        if (e != null) {
            throw new RuntimeException(e);
        }
        Packet response = c.getResponse();
        return response;
    }

    protected Call createCall(Packet request) {
        Call c = new Call();
        c.setRequest(request);
        return c;
    }

    private Packet createRequestPacket() {
        Packet request = new Packet();
        request.setName(this.name);
        request.setThreadId((int)Thread.currentThread().getId());
        return request;
    }

    protected Packet createRequestPacket(ClusterOperation operation, byte[] key, byte[] value) {
        Packet request = this.createRequestPacket();
        request.setOperation(operation);
        request.setKey(key);
        request.setValue(value);
        return request;
    }

    protected Object doOp(ClusterOperation operation, Object key, Object value) {
        Packet request = this.prepareRequest(operation, key, value);
        Packet response = this.callAndGetResult(request);
        return this.getValue(response);
    }

    protected Packet prepareRequest(ClusterOperation operation, Object key, Object value) {
        byte[] k = null;
        byte[] v = null;
        if (key != null) {
            k = Serializer.toByte(key);
        }
        if (value != null) {
            v = Serializer.toByte(value);
        }
        Packet request = this.createRequestPacket(operation, k, v);
        return request;
    }

    protected Object getValue(Packet response) {
        if (response.getValue() != null) {
            return Serializer.toObject(response.getValue());
        }
        return null;
    }

    public void destroy() {
        this.doOp(ClusterOperation.DESTROY, null, null);
        this.client.destroy(this.name);
    }

    public <K> Collection<K> keys(Predicate predicate) {
        return ((CollectionWrapper)this.doOp(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, null, predicate)).getKeys();
    }

    static void check(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null.");
        }
        if (!(obj instanceof Serializable)) {
            throw new IllegalArgumentException(obj.getClass().getName() + " is not Serializable.");
        }
    }

    static void check(EventListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener can not be null");
        }
    }

    static void check(long time, TimeUnit timeunit) {
        if (time < 0L) {
            throw new IllegalArgumentException("Time can not be less than 0.");
        }
        if (timeunit == null) {
            throw new NullPointerException("TimeUnit can not be null.");
        }
    }
}

