/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientProxy;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.OutRunnable;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.ILock;
import com.hazelcast.core.Instance;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class LockClientProxy
implements ILock,
ClientProxy {
    final ProxyHelper proxyHelper;
    final Object lockObject;
    final HazelcastClient client;

    public LockClientProxy(Object object, HazelcastClient client) {
        this.proxyHelper = new ProxyHelper("", client);
        this.lockObject = object;
        this.client = client;
    }

    public Object getLockObject() {
        return this.lockObject;
    }

    public void lock() {
        this.client.mapLockProxy.lock(this.lockObject);
    }

    public void lockInterruptibly() throws InterruptedException {
    }

    public boolean tryLock() {
        return this.client.mapLockProxy.tryLock(this.lockObject);
    }

    public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
        ProxyHelper.check(l, timeUnit);
        return this.client.mapLockProxy.tryLock(this.lockObject, l, timeUnit);
    }

    public void unlock() {
        this.client.mapLockProxy.unlock(this.lockObject);
    }

    public Condition newCondition() {
        return null;
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.LOCK;
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public Object getId() {
        return this.lockObject;
    }

    public void setOutRunnable(OutRunnable out) {
        this.proxyHelper.setOutRunnable(out);
    }
}

