/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.ClientRunnable;
import com.hazelcast.client.FutureProxy;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.impl.ClusterOperation;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorServiceManager
extends ClientRunnable {
    BlockingQueue<FutureProxy> queue = new LinkedBlockingQueue<FutureProxy>();
    AtomicLong executerId = new AtomicLong(0L);
    Map<Long, FutureProxy> map = new ConcurrentHashMap<Long, FutureProxy>();
    private final HazelcastClient client;

    public ExecutorServiceManager(HazelcastClient hazelcastClient) {
        this.client = hazelcastClient;
    }

    @Override
    protected void customRun() throws InterruptedException {
        FutureProxy future = this.queue.poll(100L, TimeUnit.MILLISECONDS);
        if (future == null) {
            return;
        }
        this.sendToExecute(future);
    }

    public void enqueue(FutureProxy<?> future) {
        this.queue.offer(future);
    }

    public void sendToExecute(FutureProxy<?> future) {
        long id = this.executerId.incrementAndGet();
        Packet request = future.proxyHelper.prepareRequest(ClusterOperation.REMOTELY_EXECUTE, future.callable, null);
        request.setLongValue(id);
        Call c = future.proxyHelper.createCall(request);
        this.map.put(id, future);
        this.client.out.enQueue(c);
    }

    public void enqueue(Packet packet) {
        FutureProxy future = this.map.get(packet.getLongValue());
        if (future != null) {
            future.enqueue(packet);
        }
        this.map.remove(packet.getLongValue());
    }
}

