/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.core.MessageListener;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MessageListenerManager {
    private final ConcurrentHashMap<String, List<MessageListener<Object>>> messageListeners = new ConcurrentHashMap();

    public void registerMessageListener(String name, MessageListener messageListener) {
        CopyOnWriteArrayList<MessageListener> newListenersList = new CopyOnWriteArrayList<MessageListener>();
        CopyOnWriteArrayList<MessageListener> listeners = this.messageListeners.putIfAbsent(name, newListenersList);
        if (listeners == null) {
            listeners = newListenersList;
        }
        listeners.add(messageListener);
    }

    public void removeMessageListener(String name, MessageListener messageListener) {
        if (!this.messageListeners.containsKey(name)) {
            return;
        }
        this.messageListeners.get(name).remove(messageListener);
        if (this.messageListeners.get(name).isEmpty()) {
            this.messageListeners.remove(name);
        }
    }

    public boolean noMessageListenerRegistered(String name) {
        if (!this.messageListeners.containsKey(name)) {
            return true;
        }
        return this.messageListeners.get(name).isEmpty();
    }

    public void notifyMessageListeners(Packet packet) {
        List<MessageListener<Object>> list = this.messageListeners.get(packet.getName());
        if (list != null) {
            for (MessageListener<Object> messageListener : list) {
                Object message = Serializer.toObject(packet.getKey());
                messageListener.onMessage(message);
            }
        }
    }
}

