/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.CollectionClientProxy;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.ISet;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.ClusterOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetClientProxy<E>
extends CollectionClientProxy<E>
implements ISet<E> {
    public SetClientProxy(HazelcastClient client, String name) {
        super(client, name);
    }

    @Override
    public boolean add(E o) {
        ProxyHelper.check(o);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_ADD_TO_SET, o, null);
    }

    @Override
    public boolean remove(Object o) {
        ProxyHelper.check(o);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REMOVE_ITEM, o, null);
    }

    @Override
    public boolean contains(Object o) {
        ProxyHelper.check(o);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_CONTAINS, o, null);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ISet && o != null) {
            return this.getName().equals(((ISet)o).getName());
        }
        return false;
    }

    public String getName() {
        return this.name.substring(4);
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.SET;
    }
}

