/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.ClientRunnable;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.NoMemberAvailableException;
import com.hazelcast.core.Member;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IORunnable
extends ClientRunnable {
    protected Map<Long, Call> callMap;
    protected final HazelcastClient client;

    public IORunnable(HazelcastClient client, Map<Long, Call> calls) {
        this.client = client;
        this.callMap = calls;
    }

    public void interruptWaitingCalls() {
        Collection<Call> calls = this.callMap.values();
        for (Call call : calls) {
            call.setResponse(new NoMemberAvailableException());
        }
        calls.clear();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.customRun();
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.notifyMonitor();
    }

    protected void onDisconnect(Connection oldConnection) {
        Member memberLeft = oldConnection.getMember();
        Collection<Call> calls = this.callMap.values();
        for (Call call : calls) {
            call.onDisconnect(memberLeft);
        }
    }

    protected boolean restoredConnection(Connection connection, boolean isOldConnectonNull, long oldConnectionId) {
        return !isOldConnectonNull && connection != null && (long)connection.getVersion() != oldConnectionId;
    }

    protected boolean restoredConnection(Connection oldConnection, Connection newConnection) {
        boolean isOldConnectionNull;
        long oldConnectionId = -1L;
        boolean bl = isOldConnectionNull = oldConnection == null;
        if (!isOldConnectionNull) {
            oldConnectionId = oldConnection.getVersion();
        }
        return this.restoredConnection(newConnection, isOldConnectionNull, oldConnectionId);
    }
}

