/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.core;

import java.util.EventObject;

public class EntryEvent
extends EventObject {
    private static final long serialVersionUID = -2296203982913729851L;
    public static final int TYPE_ADDED = 1;
    public static final int TYPE_REMOVED = 2;
    public static final int TYPE_UPDATED = 3;
    public static final int TYPE_EVICTED = 4;
    protected EntryEventType entryEventType = EntryEventType.ADDED;
    protected Object key;
    protected Object value;
    protected final String name;
    protected boolean collection;

    public EntryEvent(Object source) {
        super(source);
        this.name = (String)source;
        this.collection = this.name.charAt(0) == 't' || this.name.charAt(0) == 'q' || this.name.charAt(3) == ':';
    }

    public EntryEvent(Object source, int eventType, Object key, Object value) {
        this(source);
        this.key = key;
        this.value = value;
        if (eventType == 2) {
            this.entryEventType = EntryEventType.REMOVED;
        } else if (eventType == 3) {
            this.entryEventType = EntryEventType.UPDATED;
        } else if (eventType == 4) {
            this.entryEventType = EntryEventType.EVICTED;
        }
    }

    public Object getSource() {
        return this.name;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public EntryEventType getEventType() {
        return this.entryEventType;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "EntryEvent {" + this.getSource() + "} key=" + this.key + ", value=" + this.value + ", event=" + (Object)((Object)this.entryEventType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntryEventType {
        ADDED,
        REMOVED,
        UPDATED,
        EVICTED;

    }
}

