/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientProxy;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.client.core.EntryListener;
import com.hazelcast.client.core.IMap;
import com.hazelcast.client.core.Instance;
import com.hazelcast.client.core.MapEntry;
import com.hazelcast.client.impl.ClusterOperation;
import com.hazelcast.client.impl.Keys;
import com.hazelcast.client.query.Predicate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapClientProxy<K, V>
extends ClientProxy
implements IMap<K, V> {
    private final HazelcastClient client;

    public MapClientProxy(HazelcastClient client, String name) {
        this.name = "c:" + name;
        this.client = client;
    }

    @Override
    public void addEntryListener(EntryListener listener, boolean includeValue) {
        this.addEntryListener(listener, null, includeValue);
    }

    @Override
    public void addEntryListener(EntryListener listener, K key, boolean includeValue) {
        Packet request = this.createRequestPacket();
        request.setOperation(ClusterOperation.ADD_LISTENER);
        request.setLongValue(includeValue ? 1L : 0L);
        request.setKey(Serializer.toByte(key));
        this.callAndGetResult(request);
        this.client.listenerManager.registerEntryListener(this.name, key, listener);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        return null;
    }

    @Override
    public boolean evict(K key) {
        return false;
    }

    @Override
    public MapEntry getMapEntry(K key) {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        return null;
    }

    @Override
    public void lock(K key) {
    }

    @Override
    public void removeEntryListener(EntryListener listener) {
    }

    @Override
    public void removeEntryListener(EntryListener listener, K key) {
    }

    @Override
    public boolean tryLock(K key) {
        return false;
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit) {
        return false;
    }

    @Override
    public void unlock(K key) {
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        return null;
    }

    @Override
    public V putIfAbsent(K arg0, V arg1) {
        return null;
    }

    @Override
    public boolean remove(Object arg0, Object arg1) {
        return false;
    }

    @Override
    public V replace(K arg0, V arg1) {
        return null;
    }

    @Override
    public boolean replace(K arg0, V arg1, V arg2) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean containsKey(Object arg0) {
        return false;
    }

    @Override
    public boolean containsValue(Object arg0) {
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return null;
    }

    @Override
    public V get(Object key) {
        Packet request = this.createRequestPacket();
        request.setOperation(ClusterOperation.CONCURRENT_MAP_GET);
        request.setKey(Serializer.toByte(key));
        Packet response = this.callAndGetResult(request);
        if (response.getValue() != null) {
            return (V)Serializer.toObject(response.getValue());
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<K> keySet() {
        Packet request = this.createRequestPacket();
        request.setOperation(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS);
        Packet response = this.callAndGetResult(request);
        if (response.getValue() != null) {
            System.out.println("Response:" + response.getValue().length);
            Set set = ((Keys)Serializer.toObject(response.getValue())).getKeys();
            return set;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Packet request = this.createRequestPacket();
        request.setTxnId(0L);
        request.setOperation(ClusterOperation.CONCURRENT_MAP_PUT);
        request.setKey(Serializer.toByte(key));
        request.setValue(Serializer.toByte(value));
        Packet response = this.callAndGetResult(request);
        if (response.getValue() != null) {
            return (V)Serializer.toObject(response.getValue());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> arg0) {
    }

    @Override
    public V remove(Object arg0) {
        return null;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Collection<V> values() {
        return null;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Object getId() {
        return null;
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        return null;
    }

    abstract class MapCall {
        MapCall() {
        }

        public abstract void fillCallSpecificValues(Packet var1);

        public abstract Object processResponse(Packet var1);

        public void process() {
            Packet request = MapClientProxy.this.createRequestPacket();
            this.fillCallSpecificValues(request);
            Packet response = MapClientProxy.this.callAndGetResult(request);
        }
    }

    class MapGetCall
    extends MapCall {
        K key;
        V value;

        MapGetCall() {
        }

        public void fillCallSpecificValues(Packet request) {
            request.setTxnId(0L);
            request.setOperation(ClusterOperation.CONCURRENT_MAP_GET);
            request.setKey(Serializer.toByte(this.key));
        }

        public Object processResponse(Packet response) {
            if (response.getValue() != null) {
                return Serializer.toObject(response.getValue());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClientIterator<E>
    implements Iterator<E> {
        private Iterator<?> it;
        private String name;

        public ClientIterator(String name, Iterator<?> it) {
            this.name = name;
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            byte[] key = (byte[])this.it.next();
            MapClientProxy.this.get(key);
            return null;
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClientSet<E>
    implements Set {
        private String name;
        private Set set;

        public ClientSet(String name) {
            this.name = name;
        }

        public ClientSet(Set set) {
            this.set = set;
        }

        @Override
        public boolean add(Object e) {
            return false;
        }

        @Override
        public boolean addAll(Collection c) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection c) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator iterator() {
            return new ClientIterator(this.name, this.set.iterator());
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection c) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return null;
        }
    }
}

