/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class Connection {
    private Socket socket;
    private InetSocketAddress address;

    public Connection(String host, int port) {
        try {
            this.setSocket(SocketFactory.getDefault().createSocket(host, port));
            this.socket.setKeepAlive(true);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Connection(InetSocketAddress address) {
        this(address.getAddress().getHostAddress(), address.getPort());
        this.address = address;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }
}

