/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheSyncListenerCompleter;
import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.cache.impl.nearcache.NearCacheContext;
import com.hazelcast.cache.impl.nearcache.NearCacheExecutor;
import com.hazelcast.cache.impl.nearcache.NearCacheManager;
import com.hazelcast.client.cache.impl.AbstractClientCacheProxyBase;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheAddInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheClearCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetAndRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetAndReplaceCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveAllKeysCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheReplaceCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.AbstractMember;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractClientInternalCacheProxy<K, V>
extends AbstractClientCacheProxyBase<K, V>
implements CacheSyncListenerCompleter {
    private static final long MAX_COMPLETION_LATCH_WAIT_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final long COMPLETION_LATCH_WAIT_TIME_STEP = TimeUnit.SECONDS.toMillis(1L);
    protected final ILogger logger = Logger.getLogger(this.getClass());
    protected final HazelcastClientCacheManager cacheManager;
    protected final NearCacheManager nearCacheManager;
    protected NearCache<Data, Object> nearCache;
    protected String nearCacheMembershipRegistrationId;
    protected final ConcurrentMap<Member, String> nearCacheInvalidationListeners = new ConcurrentHashMap<Member, String>();
    private boolean cacheOnUpdate;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> asyncListenerRegistrations;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> syncListenerRegistrations;
    private final ConcurrentMap<Integer, CountDownLatch> syncLocks;

    protected AbstractClientInternalCacheProxy(CacheConfig cacheConfig, ClientContext clientContext, HazelcastClientCacheManager cacheManager) {
        super(cacheConfig, clientContext);
        this.cacheManager = cacheManager;
        this.nearCacheManager = clientContext.getNearCacheManager();
        this.asyncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncLocks = new ConcurrentHashMap<Integer, CountDownLatch>();
        this.initNearCache();
    }

    private void initNearCache() {
        NearCacheConfig nearCacheConfig = this.clientContext.getClientConfig().getNearCacheConfig(this.name);
        if (nearCacheConfig != null) {
            this.cacheOnUpdate = nearCacheConfig.getLocalUpdatePolicy() == NearCacheConfig.LocalUpdatePolicy.CACHE;
            NearCacheContext nearCacheContext = new NearCacheContext(this.clientContext.getSerializationService(), this.createNearCacheExecutor(this.clientContext.getExecutionService()));
            this.nearCache = this.nearCacheManager.getOrCreateNearCache(this.nameWithPrefix, nearCacheConfig, nearCacheContext);
            this.registerInvalidationListener();
        }
    }

    private NearCacheExecutor createNearCacheExecutor(ClientExecutionService clientExecutionService) {
        return new ClientNearCacheExecutor(clientExecutionService);
    }

    @Override
    public void close() {
        if (this.nearCache != null) {
            this.removeInvalidationListener();
            this.nearCacheManager.clearNearCache(this.nearCache.getName());
        }
        super.close();
    }

    @Override
    public void destroy() {
        if (this.nearCache != null) {
            this.removeInvalidationListener();
            this.nearCacheManager.destroyNearCache(this.nearCache.getName());
        }
        super.destroy();
    }

    protected ClientInvocationFuture invoke(ClientMessage req, Data keyData, int completionId) {
        boolean completionOperation;
        boolean bl = completionOperation = completionId != -1;
        if (completionOperation) {
            this.registerCompletionLatch(completionId, 1);
        }
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(keyData);
            HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
            ClientInvocation clientInvocation = new ClientInvocation(client, req, partitionId);
            ClientInvocationFuture f = clientInvocation.invoke();
            if (completionOperation) {
                this.waitCompletionLatch(completionId, f);
            }
            return f;
        }
        catch (Throwable e) {
            if (e instanceof IllegalStateException) {
                this.close();
            }
            if (completionOperation) {
                this.deregisterCompletionLatch(completionId);
            }
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    protected <T> T getSafely(Future<T> future) {
        try {
            return future.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow((Throwable)throwable);
        }
    }

    protected <T> ICompletableFuture<T> getAndRemoveAsyncInternal(K key, boolean withCompletionEvent) {
        ClientInvocationFuture future;
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key);
        Data keyData = this.toData(key);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheGetAndRemoveCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new ClientDelegatingFuture(future, this.clientContext.getSerializationService());
    }

    protected <T> ICompletableFuture<T> removeAsyncInternal(K key, V oldValue, boolean hasOldValue, boolean withCompletionEvent) {
        ClientInvocationFuture future;
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue);
        } else {
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key);
        }
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheRemoveCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)oldValueData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new ClientDelegatingFuture(future, this.clientContext.getSerializationService());
    }

    protected <T> ICompletableFuture<T> replaceAsyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean isGet, boolean withCompletionEvent) {
        ClientInvocationFuture future;
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, newValue);
        }
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = isGet ? CacheGetAndReplaceCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)newValueData, (Data)expiryPolicyData, (int)completionId) : CacheReplaceCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)oldValueData, (Data)newValueData, (Data)expiryPolicyData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new ClientDelegatingFuture(future, this.clientContext.getSerializationService());
    }

    protected <T> ICompletableFuture<T> putAsyncInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean isGet, boolean withCompletionEvent) {
        ClientInvocationFuture future;
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CachePutCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)valueData, (Data)expiryPolicyData, (boolean)isGet, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            if (this.cacheOnUpdate) {
                this.storeInNearCache(keyData, valueData, value);
            } else {
                this.invalidateNearCache(keyData);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new ClientDelegatingFuture(future, this.clientContext.getSerializationService());
    }

    protected ICompletableFuture<Boolean> putIfAbsentAsyncInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean withCompletionEvent) {
        ClientInvocationFuture future;
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CachePutIfAbsentCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)valueData, (Data)expiryPolicyData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            if (this.cacheOnUpdate) {
                this.storeInNearCache(keyData, valueData, value);
            } else {
                this.invalidateNearCache(keyData);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new ClientDelegatingFuture<Boolean>(future, this.clientContext.getSerializationService());
    }

    protected void removeAllKeysInternal(Set<? extends K> keys) {
        HashSet<Data> keysData;
        if (keys != null) {
            keysData = new HashSet<Data>();
            for (K key : keys) {
                keysData.add(this.toData(key));
            }
        } else {
            keysData = null;
        }
        int partitionCount = this.clientContext.getPartitionService().getPartitionCount();
        int completionId = this.nextCompletionId();
        this.registerCompletionLatch(completionId, partitionCount);
        ClientMessage request = CacheRemoveAllKeysCodec.encodeRequest((String)this.nameWithPrefix, keysData, (int)completionId);
        try {
            this.invoke(request);
            this.waitCompletionLatch(completionId, null);
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void removeAllInternal() {
        int partitionCount = this.clientContext.getPartitionService().getPartitionCount();
        int completionId = this.nextCompletionId();
        this.registerCompletionLatch(completionId, partitionCount);
        ClientMessage request = CacheRemoveAllCodec.encodeRequest((String)this.nameWithPrefix, (int)completionId);
        try {
            this.invoke(request);
            this.waitCompletionLatch(completionId, null);
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void clearInternal() {
        ClientMessage request = CacheClearCodec.encodeRequest((String)this.nameWithPrefix);
        try {
            this.invoke(request);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void storeInNearCache(Data key, Data valueData, V value) {
        if (this.nearCache != null) {
            Object valueToStore = this.nearCache.selectToSave(new Object[]{value, valueData});
            this.nearCache.put((Object)key, valueToStore);
        }
    }

    protected void invalidateNearCache(Data key) {
        if (this.nearCache != null) {
            this.nearCache.invalidate((Object)key);
        }
    }

    protected void addListenerLocally(String regId, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration.isSynchronous()) {
            this.syncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        } else {
            this.asyncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        }
    }

    protected String removeListenerLocally(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        ConcurrentMap<CacheEntryListenerConfiguration, String> regs = cacheEntryListenerConfiguration.isSynchronous() ? this.syncListenerRegistrations : this.asyncListenerRegistrations;
        return (String)regs.remove(cacheEntryListenerConfiguration);
    }

    private void deregisterAllCacheEntryListener(Collection<String> listenerRegistrations) {
        for (String regId : listenerRegistrations) {
            ClientMessage removeReq = CacheRemoveEntryListenerCodec.encodeRequest((String)this.nameWithPrefix, (String)regId);
            this.clientContext.getListenerService().stopListening(removeReq, regId);
        }
    }

    @Override
    protected void closeListeners() {
        this.deregisterAllCacheEntryListener(this.syncListenerRegistrations.values());
        this.deregisterAllCacheEntryListener(this.asyncListenerRegistrations.values());
        this.syncListenerRegistrations.clear();
        this.asyncListenerRegistrations.clear();
        this.notifyAndClearSyncListenerLatches();
    }

    private void notifyAndClearSyncListenerLatches() {
        Collection latches = this.syncLocks.values();
        Iterator iterator = latches.iterator();
        while (iterator.hasNext()) {
            CountDownLatch latch = (CountDownLatch)iterator.next();
            iterator.remove();
            while (latch.getCount() > 0L) {
                latch.countDown();
            }
        }
    }

    public void countDownCompletionLatch(int id) {
        CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(id);
        if (countDownLatch == null) {
            return;
        }
        countDownLatch.countDown();
        if (countDownLatch.getCount() == 0L) {
            this.deregisterCompletionLatch(id);
        }
    }

    protected Integer registerCompletionLatch(Integer countDownLatchId, int count) {
        if (!this.syncListenerRegistrations.isEmpty()) {
            int size = this.syncListenerRegistrations.size();
            CountDownLatch countDownLatch = new CountDownLatch(count * size);
            this.syncLocks.put(countDownLatchId, countDownLatch);
            return countDownLatchId;
        }
        return -1;
    }

    protected void deregisterCompletionLatch(Integer countDownLatchId) {
        this.syncLocks.remove(countDownLatchId);
    }

    protected void waitCompletionLatch(Integer countDownLatchId, ICompletableFuture future) throws ExecutionException {
        CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId);
        if (countDownLatch != null) {
            this.awaitLatch(countDownLatch, future);
        }
    }

    private void awaitLatch(CountDownLatch countDownLatch, ICompletableFuture future) throws ExecutionException {
        try {
            for (long currentTimeoutMs = MAX_COMPLETION_LATCH_WAIT_TIME; currentTimeoutMs > 0L && !countDownLatch.await(COMPLETION_LATCH_WAIT_TIME_STEP, TimeUnit.MILLISECONDS); currentTimeoutMs -= COMPLETION_LATCH_WAIT_TIME_STEP) {
                Object response;
                if (future != null && future.isDone() && (response = future.get()) instanceof Throwable) {
                    return;
                }
                if (!this.clientContext.isActive()) {
                    throw new HazelcastInstanceNotActiveException();
                }
                if (!this.isClosed()) continue;
                throw new IllegalStateException("Cache (" + this.nameWithPrefix + ") is closed !");
            }
            if (countDownLatch.getCount() > 0L) {
                this.logger.finest("Countdown latch wait timeout after " + MAX_COMPLETION_LATCH_WAIT_TIME + " milliseconds!");
            }
        }
        catch (InterruptedException e) {
            ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    protected EventHandler createHandler(CacheEventListenerAdaptor<K, V> adaptor) {
        return new CacheEventHandler(adaptor);
    }

    protected ICompletableFuture createCompletedFuture(Object value) {
        return new CompletedFuture(this.clientContext.getSerializationService(), value, this.clientContext.getExecutionService().getAsyncExecutor());
    }

    private void registerInvalidationListener() {
        if (this.nearCache != null && this.nearCache.isInvalidateOnChange()) {
            ClientClusterService clusterService = this.clientContext.getClusterService();
            this.nearCacheMembershipRegistrationId = clusterService.addMembershipListener(new NearCacheMembershipListener());
            Collection<Member> memberList = clusterService.getMemberList();
            for (Member member : memberList) {
                this.addInvalidationListener(member);
            }
        }
    }

    private void removeInvalidationListener() {
        if (this.nearCache != null && this.nearCache.isInvalidateOnChange()) {
            String registrationId = this.nearCacheMembershipRegistrationId;
            ClientClusterService clusterService = this.clientContext.getClusterService();
            if (registrationId != null) {
                clusterService.removeMembershipListener(registrationId);
            }
            Collection<Member> memberList = clusterService.getMemberList();
            for (Member member : memberList) {
                this.removeInvalidationListener(member, true);
            }
        }
    }

    private void addInvalidationListener(Member member) {
        if (this.nearCacheInvalidationListeners.containsKey(member)) {
            return;
        }
        try {
            ClientMessage request = CacheAddInvalidationListenerCodec.encodeRequest((String)this.nameWithPrefix);
            Client client = this.clientContext.getClusterService().getLocalClient();
            NearCacheInvalidationHandler handler = new NearCacheInvalidationHandler(client);
            HazelcastClientInstanceImpl clientInstance = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
            Address address = ((AbstractMember)member).getAddress();
            ClientInvocation invocation = new ClientInvocation(clientInstance, (EventHandler)handler, request, address);
            ClientInvocationFuture future = invocation.invoke();
            String registrationId = CacheAddInvalidationListenerCodec.decodeResponse((ClientMessage)((ClientMessage)future.get())).response;
            this.clientContext.getListenerService().registerListener(registrationId, request.getCorrelationId());
            this.nearCacheInvalidationListeners.put(member, registrationId);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private void removeInvalidationListener(Member member, boolean removeFromMemberAlso) {
        String registrationId = (String)this.nearCacheInvalidationListeners.remove(member);
        if (registrationId != null) {
            try {
                Address address = ((AbstractMember)member).getAddress();
                if (removeFromMemberAlso) {
                    ClientMessage request = CacheRemoveInvalidationListenerCodec.encodeRequest((String)this.nameWithPrefix, (String)registrationId);
                    HazelcastClientInstanceImpl clientInstance = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
                    ClientInvocation invocation = new ClientInvocation(clientInstance, request, address);
                    ClientInvocationFuture future = invocation.invoke();
                    boolean result = CacheRemoveInvalidationListenerCodec.decodeResponse((ClientMessage)((ClientMessage)future.get())).response;
                    if (!result) {
                        this.logger.warning("Invalidation listener couldn't be removed on member " + address);
                    }
                }
                this.clientContext.getListenerService().deRegisterListener(registrationId);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    private class NearCacheInvalidationHandler
    extends CacheAddInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final Client client;

        private NearCacheInvalidationHandler(Client client) {
            this.client = client;
        }

        public void handle(String name, Data key, String sourceUuid) {
            if (this.client.getUuid().equals(sourceUuid)) {
                return;
            }
            if (key != null) {
                AbstractClientInternalCacheProxy.this.nearCache.invalidate((Object)key);
            } else {
                AbstractClientInternalCacheProxy.this.nearCache.clear();
            }
        }

        public void handle(String name, Collection<Data> keys, Collection<String> sourceUuids) {
            Iterator<Data> keysIt = keys.iterator();
            Iterator<String> sourceUuidsIt = sourceUuids.iterator();
            while (keysIt.hasNext() && sourceUuidsIt.hasNext()) {
                Data key = keysIt.next();
                String sourceUuid = sourceUuidsIt.next();
                if (this.client.getUuid().equals(sourceUuid)) continue;
                AbstractClientInternalCacheProxy.this.nearCache.invalidate((Object)key);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
            AbstractClientInternalCacheProxy.this.nearCache.clear();
        }
    }

    private class NearCacheMembershipListener
    implements MembershipListener {
        private NearCacheMembershipListener() {
        }

        public void memberAdded(MembershipEvent event) {
            Member member = event.getMember();
            AbstractClientInternalCacheProxy.this.addInvalidationListener(member);
        }

        public void memberRemoved(MembershipEvent event) {
            Member member = event.getMember();
            AbstractClientInternalCacheProxy.this.removeInvalidationListener(member, false);
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }
    }

    private class CacheEventHandler
    extends CacheAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final CacheEventListenerAdaptor<K, V> adaptor;

        private CacheEventHandler(CacheEventListenerAdaptor<K, V> adaptor) {
            this.adaptor = adaptor;
        }

        public void handle(int type, Collection<CacheEventData> keys, int completionId) {
            this.adaptor.handle(type, keys, completionId);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }

    private static class ClientNearCacheExecutor
    implements NearCacheExecutor {
        private ClientExecutionService clientExecutionService;

        private ClientNearCacheExecutor(ClientExecutionService clientExecutionService) {
            this.clientExecutionService = clientExecutionService;
        }

        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.clientExecutionService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }
}

