/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerToKeyWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapClearCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapContainsValueCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapEntrySetCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapGetCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapPutAllCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapPutCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapValuesCodec;
import com.hazelcast.client.nearcache.ClientHeapNearCache;
import com.hazelcast.client.nearcache.ClientNearCache;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerRemoveCodec;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientReplicatedMapProxy<K, V>
extends ClientProxy
implements ReplicatedMap<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private volatile ClientHeapNearCache<Object> nearCache;
    private final AtomicBoolean nearCacheInitialized = new AtomicBoolean();

    public ClientReplicatedMapProxy(String serviceName, String objectName) {
        super(serviceName, objectName);
    }

    @Override
    protected void onDestroy() {
        if (this.nearCache != null) {
            this.removeNearCacheInvalidationListener();
            this.nearCache.destroy();
        }
    }

    public V put(K key, V value, long ttl, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapPutCodec.encodeRequest((String)this.getName(), (Data)keyData, (Data)valueData, (long)timeUnit.toMillis(ttl));
        ClientMessage response = (ClientMessage)this.invoke(request);
        ReplicatedMapPutCodec.ResponseParameters result = ReplicatedMapPutCodec.decodeResponse((ClientMessage)response);
        return (V)this.toObject(result.response);
    }

    public int size() {
        ClientMessage request = ReplicatedMapSizeCodec.encodeRequest((String)this.getName());
        ClientMessage response = (ClientMessage)this.invoke(request);
        ReplicatedMapSizeCodec.ResponseParameters result = ReplicatedMapSizeCodec.decodeResponse((ClientMessage)response);
        return result.response;
    }

    public boolean isEmpty() {
        ClientMessage request = ReplicatedMapIsEmptyCodec.encodeRequest((String)this.getName());
        ClientMessage response = (ClientMessage)this.invoke(request);
        ReplicatedMapIsEmptyCodec.ResponseParameters result = ReplicatedMapIsEmptyCodec.decodeResponse((ClientMessage)response);
        return result.response;
    }

    public boolean containsKey(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapContainsKeyCodec.encodeRequest((String)this.getName(), (Data)keyData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        ReplicatedMapContainsKeyCodec.ResponseParameters result = ReplicatedMapContainsKeyCodec.decodeResponse((ClientMessage)response);
        return result.response;
    }

    public boolean containsValue(Object value) {
        Preconditions.checkNotNull((Object)value, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        ClientMessage request = ReplicatedMapContainsValueCodec.encodeRequest((String)this.getName(), (Data)valueData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        ReplicatedMapContainsValueCodec.ResponseParameters result = ReplicatedMapContainsValueCodec.decodeResponse((ClientMessage)response);
        return result.response;
    }

    public V get(Object key) {
        Object cached;
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        this.initNearCache();
        if (this.nearCache != null && (cached = this.nearCache.get(key)) != null) {
            if (cached.equals(ClientNearCache.NULL_OBJECT)) {
                return null;
            }
            return (V)cached;
        }
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapGetCodec.encodeRequest((String)this.getName(), (Data)keyData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        ReplicatedMapGetCodec.ResponseParameters result = ReplicatedMapGetCodec.decodeResponse((ClientMessage)response);
        Object value = this.toObject(result.response);
        if (this.nearCache != null) {
            this.nearCache.put(key, value);
        }
        return (V)value;
    }

    public V put(K key, V value) {
        return this.put(key, value, 0L, TimeUnit.MILLISECONDS);
    }

    public V remove(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapRemoveCodec.encodeRequest((String)this.getName(), (Data)keyData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        ReplicatedMapRemoveCodec.ResponseParameters result = ReplicatedMapRemoveCodec.decodeResponse((ClientMessage)response);
        return (V)this.toObject(result.response);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        HashMap<Data, Data> map = new HashMap<Data, Data>();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            Data keyData = this.toData(entry.getKey());
            map.put(keyData, this.toData(entry.getValue()));
        }
        ClientMessage request = ReplicatedMapPutAllCodec.encodeRequest((String)this.getName(), map);
        this.invoke(request);
    }

    public void clear() {
        ClientMessage request = ReplicatedMapClearCodec.encodeRequest((String)this.getName());
        this.invoke(request);
    }

    public boolean removeEntryListener(String registrationId) {
        final String name = this.getName();
        return this.stopListening(registrationId, new ListenerRemoveCodec(){

            @Override
            public ClientMessage encodeRequest(String realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest((String)name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        });
    }

    public String addEntryListener(EntryListener<K, V> listener) {
        ClientMessage request = ReplicatedMapAddEntryListenerCodec.encodeRequest((String)this.getName());
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)ReplicatedMapAddEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, null, handler, responseDecoder);
    }

    public String addEntryListener(EntryListener<K, V> listener, K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapAddEntryListenerToKeyCodec.encodeRequest((String)this.getName(), (Data)keyData);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)ReplicatedMapAddEntryListenerToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, keyData, handler, responseDecoder);
    }

    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate) {
        Data predicateData = this.toData(predicate);
        ClientMessage request = ReplicatedMapAddEntryListenerWithPredicateCodec.encodeRequest((String)this.getName(), (Data)predicateData);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)ReplicatedMapAddEntryListenerWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, null, handler, responseDecoder);
    }

    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data predicateData = this.toData(predicate);
        ClientMessage request = ReplicatedMapAddEntryListenerToKeyWithPredicateCodec.encodeRequest((String)this.getName(), (Data)keyData, (Data)predicateData);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)ReplicatedMapAddEntryListenerToKeyWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, keyData, handler, responseDecoder);
    }

    public Set<K> keySet() {
        ClientMessage request = ReplicatedMapKeySetCodec.encodeRequest((String)this.getName());
        ClientMessage response = (ClientMessage)this.invoke(request);
        ReplicatedMapKeySetCodec.ResponseParameters result = ReplicatedMapKeySetCodec.decodeResponse((ClientMessage)response);
        HashSet resultSet = new HashSet(result.list.size());
        for (Data data : result.list) {
            resultSet.add(this.toObject(data));
        }
        return resultSet;
    }

    public Collection<V> values() {
        ClientMessage request = ReplicatedMapValuesCodec.encodeRequest((String)this.getName());
        ClientMessage response = (ClientMessage)this.invoke(request);
        ReplicatedMapValuesCodec.ResponseParameters result = ReplicatedMapValuesCodec.decodeResponse((ClientMessage)response);
        ArrayList resultCollection = new ArrayList(result.list.size());
        for (Data data : result.list) {
            resultCollection.add(this.toObject(data));
        }
        return resultCollection;
    }

    public Collection<V> values(Comparator<V> comparator) {
        List values = (List)this.values();
        Collections.sort(values, comparator);
        return values;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = ReplicatedMapEntrySetCodec.encodeRequest((String)this.getName());
        ClientMessage response = (ClientMessage)this.invoke(request);
        ReplicatedMapEntrySetCodec.ResponseParameters result = ReplicatedMapEntrySetCodec.decodeResponse((ClientMessage)response);
        HashSet<Map.Entry<K, V>> resultCollection = new HashSet<Map.Entry<K, V>>(result.map.size());
        for (Map.Entry dataEntry : result.map.entrySet()) {
            Object key = this.toObject(dataEntry.getKey());
            Object value = this.toObject(dataEntry.getValue());
            resultCollection.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        return resultCollection;
    }

    private EventHandler<ClientMessage> createHandler(EntryListener<K, V> listener) {
        return new ReplicatedMapEventHandler(listener);
    }

    private void initNearCache() {
        if (this.nearCacheInitialized.compareAndSet(false, true)) {
            NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.getName());
            if (nearCacheConfig == null) {
                return;
            }
            ClientHeapNearCache nearCache = new ClientHeapNearCache(this.getName(), this.getContext(), nearCacheConfig);
            this.nearCache = nearCache;
            if (nearCache.isInvalidateOnChange()) {
                this.addNearCacheInvalidateListener();
            }
        }
    }

    private void addNearCacheInvalidateListener() {
        try {
            ClientMessage request = ReplicatedMapAddNearCacheEntryListenerCodec.encodeRequest((String)this.getName(), (boolean)false);
            ReplicatedMapAddNearCacheEventHandler handler = new ReplicatedMapAddNearCacheEventHandler();
            String registrationId = this.getContext().getListenerService().startListening(request, null, handler, new ClientMessageDecoder(){

                @Override
                public <T> T decodeClientMessage(ClientMessage clientMessage) {
                    return (T)ReplicatedMapAddNearCacheEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
                }
            });
            this.nearCache.setId(registrationId);
        }
        catch (Exception e) {
            Logger.getLogger(ClientHeapNearCache.class).severe("-----------------\n Near Cache is not initialized!!! \n-----------------", (Throwable)e);
        }
    }

    private void removeNearCacheInvalidationListener() {
        if (this.nearCache != null && this.nearCache.getId() != null) {
            String registrationId = this.nearCache.getId();
            final String name = this.getName();
            this.getContext().getListenerService().stopListening(registrationId, new ListenerRemoveCodec(){

                @Override
                public ClientMessage encodeRequest(String realRegistrationId) {
                    return ReplicatedMapRemoveEntryListenerCodec.encodeRequest((String)name, (String)realRegistrationId);
                }

                @Override
                public boolean decodeResponse(ClientMessage clientMessage) {
                    return ReplicatedMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
                }
            });
        }
    }

    public String toString() {
        return "ReplicatedMap{name='" + this.getName() + '\'' + '}';
    }

    private class ReplicatedMapAddNearCacheEventHandler
    extends ReplicatedMapAddNearCacheEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private ReplicatedMapAddNearCacheEventHandler() {
        }

        @Override
        public void beforeListenerRegister() {
            if (ClientReplicatedMapProxy.this.nearCache != null) {
                ClientReplicatedMapProxy.this.nearCache.clear();
            }
        }

        @Override
        public void onListenerRegister() {
            if (ClientReplicatedMapProxy.this.nearCache != null) {
                ClientReplicatedMapProxy.this.nearCache.clear();
            }
        }

        public void handle(Data key, Data value, Data oldValue, Data mergingValue, int eventType, String uuid, int numberOfAffectedEntries) {
            EntryEventType entryEventType = EntryEventType.getByType((int)eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: {
                    ClientReplicatedMapProxy.this.nearCache.remove(ClientReplicatedMapProxy.this.toObject(key));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + entryEventType);
                }
            }
        }
    }

    private class ReplicatedMapEventHandler
    extends ReplicatedMapAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final EntryListener<K, V> listener;

        public ReplicatedMapEventHandler(EntryListener<K, V> listener) {
            this.listener = listener;
        }

        public void handle(Data keyData, Data valueData, Data oldValueData, Data mergingValue, int eventTypeId, String uuid, int numberOfAffectedEntries) {
            Object value = ClientReplicatedMapProxy.this.toObject(valueData);
            Object oldValue = ClientReplicatedMapProxy.this.toObject(oldValueData);
            Object key = ClientReplicatedMapProxy.this.toObject(keyData);
            Member member = ClientReplicatedMapProxy.this.getContext().getClusterService().getMember(uuid);
            EntryEventType eventType = EntryEventType.getByType((int)eventTypeId);
            EntryEvent entryEvent = new EntryEvent((Object)ClientReplicatedMapProxy.this.getName(), member, eventTypeId, key, oldValue, value);
            switch (eventType) {
                case ADDED: {
                    this.listener.entryAdded(entryEvent);
                    break;
                }
                case REMOVED: {
                    this.listener.entryRemoved(entryEvent);
                    break;
                }
                case UPDATED: {
                    this.listener.entryUpdated(entryEvent);
                    break;
                }
                case EVICTED: {
                    this.listener.entryEvicted(entryEvent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + eventType);
                }
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

