/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AtomicLongAddAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongAlterAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongApplyCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongCompareAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongDecrementAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndAddCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndIncrementCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongIncrementAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongSetCodec;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IFunction;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;

public class ClientAtomicLongProxy
extends ClientProxy
implements IAtomicLong {
    private final String name;
    private volatile Data key;

    public ClientAtomicLongProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    public <R> R apply(IFunction<Long, R> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicLongApplyCodec.encodeRequest((String)this.name, (Data)this.toData(function));
        ClientMessage response = this.invokeMessage(request);
        AtomicLongApplyCodec.ResponseParameters resultParameters = AtomicLongApplyCodec.decodeResponse((ClientMessage)response);
        return (R)this.toObject(resultParameters.response);
    }

    public void alter(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicLongAlterCodec.encodeRequest((String)this.name, (Data)this.toData(function));
        this.invokeMessage(request);
    }

    public long alterAndGet(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicLongAlterAndGetCodec.encodeRequest((String)this.name, (Data)this.toData(function));
        AtomicLongAlterAndGetCodec.ResponseParameters resultParameters = AtomicLongAlterAndGetCodec.decodeResponse((ClientMessage)this.invokeMessage(request));
        return resultParameters.response;
    }

    public long getAndAlter(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, (String)"function");
        ClientMessage request = AtomicLongGetAndAlterCodec.encodeRequest((String)this.name, (Data)this.toData(function));
        AtomicLongGetAndAlterCodec.ResponseParameters resultParameters = AtomicLongGetAndAlterCodec.decodeResponse((ClientMessage)this.invokeMessage(request));
        return resultParameters.response;
    }

    public long addAndGet(long delta) {
        ClientMessage request = AtomicLongAddAndGetCodec.encodeRequest((String)this.name, (long)delta);
        AtomicLongAddAndGetCodec.ResponseParameters resultParameters = AtomicLongAddAndGetCodec.decodeResponse((ClientMessage)this.invokeMessage(request));
        return resultParameters.response;
    }

    public boolean compareAndSet(long expect, long update) {
        ClientMessage request = AtomicLongCompareAndSetCodec.encodeRequest((String)this.name, (long)expect, (long)update);
        AtomicLongCompareAndSetCodec.ResponseParameters resultParameters = AtomicLongCompareAndSetCodec.decodeResponse((ClientMessage)this.invokeMessage(request));
        return resultParameters.response;
    }

    public long decrementAndGet() {
        ClientMessage request = AtomicLongDecrementAndGetCodec.encodeRequest((String)this.name);
        AtomicLongDecrementAndGetCodec.ResponseParameters resultParameters = AtomicLongDecrementAndGetCodec.decodeResponse((ClientMessage)this.invokeMessage(request));
        return resultParameters.response;
    }

    public long get() {
        ClientMessage request = AtomicLongGetCodec.encodeRequest((String)this.name);
        AtomicLongGetCodec.ResponseParameters resultParameters = AtomicLongGetCodec.decodeResponse((ClientMessage)this.invokeMessage(request));
        return resultParameters.response;
    }

    public long getAndAdd(long delta) {
        ClientMessage request = AtomicLongGetAndAddCodec.encodeRequest((String)this.name, (long)delta);
        AtomicLongGetAndAddCodec.ResponseParameters resultParameters = AtomicLongGetAndAddCodec.decodeResponse((ClientMessage)this.invokeMessage(request));
        return resultParameters.response;
    }

    public long getAndSet(long newValue) {
        ClientMessage request = AtomicLongGetAndSetCodec.encodeRequest((String)this.name, (long)newValue);
        AtomicLongGetAndSetCodec.ResponseParameters resultParameters = AtomicLongGetAndSetCodec.decodeResponse((ClientMessage)this.invokeMessage(request));
        return resultParameters.response;
    }

    public long incrementAndGet() {
        ClientMessage request = AtomicLongIncrementAndGetCodec.encodeRequest((String)this.name);
        AtomicLongIncrementAndGetCodec.ResponseParameters resultParameters = AtomicLongIncrementAndGetCodec.decodeResponse((ClientMessage)this.invokeMessage(request));
        return resultParameters.response;
    }

    public long getAndIncrement() {
        ClientMessage request = AtomicLongGetAndIncrementCodec.encodeRequest((String)this.name);
        AtomicLongGetAndIncrementCodec.ResponseParameters resultParameters = AtomicLongGetAndIncrementCodec.decodeResponse((ClientMessage)this.invokeMessage(request));
        return resultParameters.response;
    }

    public void set(long newValue) {
        ClientMessage request = AtomicLongSetCodec.encodeRequest((String)this.name, (long)newValue);
        this.invokeMessage(request);
    }

    protected ClientMessage invokeMessage(ClientMessage req) {
        return (ClientMessage)super.invoke(req, this.getKey());
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.toData(this.name);
        }
        return this.key;
    }

    public String toString() {
        return "IAtomicLong{name='" + this.name + '\'' + '}';
    }
}

