/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.AbstractClientSelectionHandler;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ClientMessageBuilder;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.util.Clock;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ClientReadHandler
extends AbstractClientSelectionHandler {
    private final ByteBuffer buffer;
    private final ClientMessageBuilder builder;
    private volatile long lastHandle;

    public ClientReadHandler(final ClientConnection connection, IOSelector ioSelector, int bufferSize) {
        super(connection, ioSelector);
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.lastHandle = Clock.currentTimeMillis();
        this.builder = new ClientMessageBuilder(new ClientMessageBuilder.MessageHandler(){

            public void handleMessage(ClientMessage message) {
                ClientReadHandler.this.connectionManager.handleClientMessage(message, connection);
            }
        });
    }

    @Override
    public void run() {
        this.registerOp(1);
    }

    public void handle() {
        this.lastHandle = Clock.currentTimeMillis();
        if (!this.connection.isAlive()) {
            if (this.logger.isFinestEnabled()) {
                String message = "We are being asked to read, but connection is not live so we won't";
                this.logger.finest(message);
            }
            return;
        }
        try {
            int readBytes = this.socketChannel.read(this.buffer);
            if (readBytes == -1) {
                throw new EOFException("Remote socket closed!");
            }
        }
        catch (IOException e) {
            this.handleSocketException(e);
            return;
        }
        try {
            if (this.buffer.position() == 0) {
                return;
            }
            this.buffer.flip();
            this.builder.onData(this.buffer);
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
        }
        catch (Throwable t) {
            this.handleSocketException(t);
        }
    }

    long getLastHandle() {
        return this.lastHandle;
    }
}

