/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientRegistrationKey;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.util.UuidUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientNonSmartListenerService
extends ClientListenerServiceImpl
implements ConnectionListener {
    private final Map<ClientRegistrationKey, ClientEventRegistration> registrations = new ConcurrentHashMap<ClientRegistrationKey, ClientEventRegistration>();
    private final Object listenerRegLock = new Object();

    public ClientNonSmartListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        super(client, eventThreadCount, eventQueueCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String registerListener(BaseClientAddListenerRequest addRequest, BaseClientRemoveListenerRequest removeRequest, EventHandler handler) {
        Object object = this.listenerRegLock;
        synchronized (object) {
            String userRegistrationId = UuidUtil.newUnsecureUuidString();
            ClientRegistrationKey registrationKey = new ClientRegistrationKey(userRegistrationId, addRequest, removeRequest, handler);
            try {
                ClientEventRegistration registration = this.invoke(registrationKey);
                this.registrations.put(registrationKey, registration);
            }
            catch (Exception e) {
                throw new HazelcastException("Listener can not be added", (Throwable)e);
            }
            return userRegistrationId;
        }
    }

    public ClientEventRegistration invoke(ClientRegistrationKey registrationKey) throws Exception {
        EventHandler handler = registrationKey.getHandler();
        handler.beforeListenerRegister();
        BaseClientAddListenerRequest addRequest = registrationKey.getAddRequest();
        BaseClientRemoveListenerRequest removeRequest = registrationKey.getRemoveRequest();
        ClientInvocation invocation = new ClientInvocation(this.client, handler, (ClientRequest)addRequest);
        ClientInvocationFuture future = invocation.invoke();
        String registrationId = (String)this.serializationService.toObject(future.get());
        handler.onListenerRegister();
        Address address = future.getInvocation().getSendConnection().getRemoteEndpoint();
        return new ClientEventRegistration(registrationId, addRequest.getCallId(), address, removeRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deregisterListener(String userRegistrationId) {
        Object object = this.listenerRegLock;
        synchronized (object) {
            ClientRegistrationKey key = new ClientRegistrationKey(userRegistrationId);
            ClientEventRegistration registration = this.registrations.get(key);
            if (registration == null) {
                return false;
            }
            BaseClientRemoveListenerRequest removeRequest = registration.getRemoveRequest();
            removeRequest.setRegistrationId(registration.getServerRegistrationId());
            try {
                ClientInvocationFuture future = new ClientInvocation(this.client, (ClientRequest)removeRequest).invoke();
                future.get();
                this.removeEventHandler(registration.getCallId());
                this.registrations.remove(key);
            }
            catch (Exception e) {
                throw new HazelcastException("Listener with id " + userRegistrationId + " could not be removed", (Throwable)e);
            }
            return true;
        }
    }

    @Override
    public void start() {
        this.client.getConnectionManager().addConnectionListener(this);
    }

    public void connectionAdded(Connection connection) {
        this.executionService.executeInternal(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ClientNonSmartListenerService.this.listenerRegLock;
                synchronized (object) {
                    for (ClientRegistrationKey registrationKey : ClientNonSmartListenerService.this.registrations.keySet()) {
                        try {
                            ClientEventRegistration registration = ClientNonSmartListenerService.this.invoke(registrationKey);
                            ClientNonSmartListenerService.this.registrations.put(registrationKey, registration);
                        }
                        catch (Exception e) {
                            ClientNonSmartListenerService.this.logger.warning("Listener " + registrationKey + " could not be added ");
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionRemoved(Connection connection) {
        Object object = this.listenerRegLock;
        synchronized (object) {
            for (Map.Entry<ClientRegistrationKey, ClientEventRegistration> entry : this.registrations.entrySet()) {
                this.removeEventHandler(entry.getValue().getCallId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClientEventRegistration> getActiveRegistrations(String uuid) {
        Object object = this.listenerRegLock;
        synchronized (object) {
            ClientEventRegistration registration = this.registrations.get(new ClientRegistrationKey(uuid));
            if (registration == null) {
                return Collections.EMPTY_LIST;
            }
            LinkedList<ClientEventRegistration> activeRegistrations = new LinkedList<ClientEventRegistration>();
            if (this.getEventHandler(registration.getCallId()) != null) {
                activeRegistrations.add(registration);
            }
            return activeRegistrations;
        }
    }
}

