/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.connection.Authenticator;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.AuthenticationRequest;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.security.Credentials;
import com.hazelcast.spi.impl.SerializableList;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.util.Iterator;

public class ClusterAuthenticator
implements Authenticator {
    private final HazelcastClientInstanceImpl client;
    private final Credentials credentials;

    public ClusterAuthenticator(HazelcastClientInstanceImpl client, Credentials credentials) {
        this.client = client;
        this.credentials = credentials;
    }

    @Override
    public void authenticate(ClientConnection connection) throws AuthenticationException, IOException {
        SerializableList collectionWrapper;
        ClientClusterServiceImpl clusterService = (ClientClusterServiceImpl)this.client.getClientClusterService();
        ClientPrincipal principal = clusterService.getPrincipal();
        SerializationService ss = this.client.getSerializationService();
        AuthenticationRequest auth = new AuthenticationRequest(this.credentials, principal);
        ClientInvocation clientInvocation = new ClientInvocation(this.client, (ClientRequest)auth, connection);
        ClientInvocationFuture future = clientInvocation.invokeUrgent();
        try {
            collectionWrapper = (SerializableList)ss.toObject(future.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e, IOException.class);
        }
        Iterator iter = collectionWrapper.iterator();
        Data addressData = (Data)iter.next();
        Address address = (Address)ss.toObject((Object)addressData);
        connection.setRemoteEndpoint(address);
    }
}

