/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.cache.impl.client.CacheGetAllRequest;
import com.hazelcast.cache.impl.client.CacheGetRequest;
import com.hazelcast.cache.impl.client.CachePutAllRequest;
import com.hazelcast.cache.impl.client.CacheSizeRequest;
import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.client.cache.impl.AbstractClientInternalCacheProxy;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.cache.CacheException;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractClientCacheProxy<K, V>
extends AbstractClientInternalCacheProxy<K, V>
implements ICacheInternal<K, V> {
    protected AbstractClientCacheProxy(CacheConfig cacheConfig, ClientContext clientContext, HazelcastClientCacheManager cacheManager) {
        super(cacheConfig, clientContext, cacheManager);
    }

    protected Object getFromNearCache(Data keyData, boolean async) {
        Object cached;
        Object object = cached = this.nearCache != null ? this.nearCache.get((Object)keyData) : null;
        if (cached != null && NearCache.NULL_OBJECT != cached) {
            return !async ? cached : this.createCompletedFuture(cached);
        }
        return null;
    }

    protected Object getInternal(K key, ExpiryPolicy expiryPolicy, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        final Data keyData = this.toData(key);
        Object cached = this.getFromNearCache(keyData, async);
        if (cached != null) {
            return cached;
        }
        CacheGetRequest request = new CacheGetRequest(this.nameWithPrefix, keyData, expiryPolicy, this.cacheConfig.getInMemoryFormat());
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(key);
            HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
            ClientInvocation clientInvocation = new ClientInvocation(client, (ClientRequest)request, partitionId);
            future = clientInvocation.invoke();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        if (async) {
            if (this.nearCache != null) {
                future.andThenInternal(new ExecutionCallback<Data>(){

                    public void onResponse(Data valueData) {
                        AbstractClientCacheProxy.this.storeInNearCache(keyData, valueData, null);
                        if (AbstractClientCacheProxy.this.statisticsEnabled) {
                            AbstractClientCacheProxy.this.handleStatisticsOnGet(start, valueData);
                        }
                    }

                    public void onFailure(Throwable t) {
                    }
                });
            }
            return new DelegatingFuture((ICompletableFuture)future, this.clientContext.getSerializationService());
        }
        try {
            Object value = future.get();
            Object result = this.toObject(value);
            if (this.nearCache != null) {
                this.storeInNearCache(keyData, this.toData(value), result);
            }
            if (this.statisticsEnabled) {
                this.handleStatisticsOnGet(start, result);
            }
            return result;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    protected void handleStatisticsOnGet(long start, Object response) {
        if (response == null) {
            this.statistics.increaseCacheMisses();
        } else {
            this.statistics.increaseCacheHits();
        }
        this.statistics.addGetTimeNanos(System.nanoTime() - start);
    }

    public ICompletableFuture<V> getAsync(K key) {
        return this.getAsync(key, null);
    }

    public ICompletableFuture<V> getAsync(K key, ExpiryPolicy expiryPolicy) {
        return (ICompletableFuture)this.getInternal(key, expiryPolicy, true);
    }

    public ICompletableFuture<Void> putAsync(K key, V value) {
        return this.putAsync(key, value, null);
    }

    public ICompletableFuture<Void> putAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return (ICompletableFuture)this.putInternal(key, value, expiryPolicy, false, true, true);
    }

    public ICompletableFuture<Boolean> putIfAbsentAsync(K key, V value) {
        return (ICompletableFuture)this.putIfAbsentInternal(key, value, null, false, true);
    }

    public ICompletableFuture<Boolean> putIfAbsentAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return (ICompletableFuture)this.putIfAbsentInternal(key, value, expiryPolicy, false, true);
    }

    public ICompletableFuture<V> getAndPutAsync(K key, V value) {
        return this.getAndPutAsync(key, value, null);
    }

    public ICompletableFuture<V> getAndPutAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return (ICompletableFuture)this.putInternal(key, value, expiryPolicy, true, false, true);
    }

    public ICompletableFuture<Boolean> removeAsync(K key) {
        return this.removeAsyncInternal(key, null, false, false, false, true);
    }

    public ICompletableFuture<Boolean> removeAsync(K key, V oldValue) {
        return this.removeAsyncInternal(key, oldValue, true, false, false, true);
    }

    public ICompletableFuture<V> getAndRemoveAsync(K key) {
        return this.removeAsyncInternal(key, null, false, true, false, true);
    }

    public ICompletableFuture<Boolean> replaceAsync(K key, V value) {
        return this.replaceAsyncInternal(key, null, value, null, false, false, false, true);
    }

    public ICompletableFuture<Boolean> replaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, null, value, expiryPolicy, false, false, false, true);
    }

    public ICompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsyncInternal(key, oldValue, newValue, null, true, false, false, true);
    }

    public ICompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, oldValue, newValue, expiryPolicy, true, false, false, true);
    }

    public ICompletableFuture<V> getAndReplaceAsync(K key, V value) {
        return this.replaceAsyncInternal(key, null, value, null, false, true, false, true);
    }

    public ICompletableFuture<V> getAndReplaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, null, value, expiryPolicy, false, true, false, true);
    }

    public V get(K key, ExpiryPolicy expiryPolicy) {
        return (V)this.getInternal(key, expiryPolicy, false);
    }

    public Map<K, V> getAll(Set<? extends K> keys, ExpiryPolicy expiryPolicy) {
        long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        if (keys.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashSet<Data> keySet = new HashSet<Data>(keys.size());
        for (K key : keys) {
            Data k = this.toData(key);
            keySet.add(k);
        }
        Map result = this.getAllFromNearCache(keySet);
        CacheGetAllRequest request = new CacheGetAllRequest(this.nameWithPrefix, keySet, expiryPolicy);
        MapEntries mapEntries = (MapEntries)this.invoke((ClientRequest)request);
        for (Map.Entry dataEntry : mapEntries) {
            Data keyData = (Data)dataEntry.getKey();
            Data valueData = (Data)dataEntry.getValue();
            Object key = this.toObject(keyData);
            Object value = this.toObject(valueData);
            result.put(key, value);
            this.storeInNearCache(keyData, valueData, value);
        }
        if (this.statisticsEnabled) {
            this.statistics.increaseCacheHits(mapEntries.size());
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
        }
        return result;
    }

    private Map<K, V> getAllFromNearCache(Set<Data> keySet) {
        HashMap result = new HashMap();
        if (this.nearCache != null) {
            Iterator<Data> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                Data key = iterator.next();
                Object cached = this.nearCache.get((Object)key);
                if (cached == null || NearCache.NULL_OBJECT.equals(cached)) continue;
                result.put(this.toObject(key), cached);
                iterator.remove();
            }
        }
        return result;
    }

    public void put(K key, V value, ExpiryPolicy expiryPolicy) {
        this.putInternal(key, value, expiryPolicy, false, true, false);
    }

    public V getAndPut(K key, V value, ExpiryPolicy expiryPolicy) {
        return (V)this.putInternal(key, value, expiryPolicy, true, true, false);
    }

    public void putAll(Map<? extends K, ? extends V> map, ExpiryPolicy expiryPolicy) {
        long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(map);
        ClientPartitionService partitionService = this.clientContext.getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        try {
            List<Map.Entry<Data, Data>>[] entriesPerPartition = this.groupDataToPartitions(map, partitionService, partitionCount);
            this.putToAllPartitionsAndWaitForCompletion(entriesPerPartition, expiryPolicy, start);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private List<Map.Entry<Data, Data>>[] groupDataToPartitions(Map<? extends K, ? extends V> map, ClientPartitionService partitionService, int partitionCount) {
        List[] entriesPerPartition = new List[partitionCount];
        SerializationService serializationService = this.clientContext.getSerializationService();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            CacheProxyUtil.validateNotNull(key, value);
            Data keyData = serializationService.toData(key);
            Data valueData = serializationService.toData(value);
            int partitionId = partitionService.getPartitionId(keyData);
            ArrayList<AbstractMap.SimpleImmutableEntry<Data, Data>> entries = entriesPerPartition[partitionId];
            if (entries == null) {
                entriesPerPartition[partitionId] = entries = new ArrayList<AbstractMap.SimpleImmutableEntry<Data, Data>>();
            }
            entries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, valueData));
        }
        return entriesPerPartition;
    }

    private void putToAllPartitionsAndWaitForCompletion(List<Map.Entry<Data, Data>>[] entriesPerPartition, ExpiryPolicy expiryPolicy, long start) throws ExecutionException, InterruptedException {
        ArrayList<FutureEntriesTuple> futureEntriesTuples = new ArrayList<FutureEntriesTuple>(entriesPerPartition.length);
        for (int partitionId = 0; partitionId < entriesPerPartition.length; ++partitionId) {
            List<Map.Entry<Data, Data>> entries = entriesPerPartition[partitionId];
            if (entries == null) continue;
            CachePutAllRequest request = new CachePutAllRequest(this.nameWithPrefix, this.cacheConfig.getInMemoryFormat(), entries, expiryPolicy, partitionId);
            ClientInvocationFuture f = this.invoke((ClientRequest)request, partitionId, true);
            futureEntriesTuples.add(new FutureEntriesTuple((Future)((Object)f), entries));
        }
        this.waitResponseFromAllPartitionsForPutAll(futureEntriesTuples, start);
    }

    private void waitResponseFromAllPartitionsForPutAll(List<FutureEntriesTuple> futureEntriesTuples, long start) {
        Throwable error = null;
        for (FutureEntriesTuple tuple : futureEntriesTuples) {
            Future future = tuple.future;
            List entries = tuple.entries;
            try {
                future.get();
                if (this.nearCache != null) {
                    this.handleNearCacheOnPutAll(entries, !this.cacheOnUpdate);
                }
                if (!this.statisticsEnabled) continue;
                this.statistics.increaseCachePuts(entries.size());
            }
            catch (Throwable t) {
                if (this.nearCache != null) {
                    this.handleNearCacheOnPutAll(entries, true);
                }
                this.logger.finest("Error occurred while putting entries as batch!", t);
                if (error != null) continue;
                error = t;
            }
        }
        if (this.statisticsEnabled) {
            this.statistics.addPutTimeNanos(System.nanoTime() - start);
        }
        if (error != null) {
            ExceptionUtil.rethrow(error);
        }
    }

    private void handleNearCacheOnPutAll(List<Map.Entry<Data, Data>> entries, boolean invalidate) {
        if (invalidate) {
            for (Map.Entry<Data, Data> entry : entries) {
                this.nearCache.remove((Object)entry.getKey());
            }
        } else {
            for (Map.Entry<Data, Data> entry : entries) {
                this.nearCache.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    public boolean putIfAbsent(K key, V value, ExpiryPolicy expiryPolicy) {
        return (Boolean)this.putIfAbsentInternal(key, value, expiryPolicy, true, false);
    }

    public boolean replace(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        long start = System.nanoTime();
        ICompletableFuture f = this.replaceAsyncInternal(key, oldValue, newValue, expiryPolicy, true, false, true, false);
        try {
            boolean replaced = (Boolean)f.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnReplace(false, start, replaced);
            }
            return replaced;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public boolean replace(K key, V value, ExpiryPolicy expiryPolicy) {
        long start = System.nanoTime();
        ICompletableFuture f = this.replaceAsyncInternal(key, null, value, expiryPolicy, false, false, true, false);
        try {
            boolean replaced = (Boolean)f.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnReplace(false, start, replaced);
            }
            return replaced;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public V getAndReplace(K key, V value, ExpiryPolicy expiryPolicy) {
        long start = System.nanoTime();
        ICompletableFuture f = this.replaceAsyncInternal(key, null, value, expiryPolicy, false, true, true, false);
        try {
            Object oldValue = f.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnReplace(true, start, oldValue);
            }
            return oldValue;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public int size() {
        this.ensureOpen();
        try {
            CacheSizeRequest request = new CacheSizeRequest(this.nameWithPrefix);
            Integer result = (Integer)this.invoke((ClientRequest)request);
            if (result == null) {
                return 0;
            }
            return result;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    public CacheStatistics getLocalCacheStatistics() {
        return this.statistics;
    }

    private static final class FutureEntriesTuple {
        private Future future;
        private List<Map.Entry<Data, Data>> entries;

        private FutureEntriesTuple(Future future, List<Map.Entry<Data, Data>> entries) {
            this.future = future;
            this.entries = entries;
        }
    }
}

