/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientResponse;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.executor.StripedExecutor;
import com.hazelcast.util.executor.StripedRunnable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;

public abstract class ClientListenerServiceImpl
implements ClientListenerService {
    protected final HazelcastClientInstanceImpl client;
    protected final ClientExecutionServiceImpl executionService;
    protected final SerializationService serializationService;
    protected final ClientInvocationService invocationService;
    protected final ILogger logger = Logger.getLogger(ClientListenerService.class);
    private final ConcurrentMap<Long, EventHandler> eventHandlerMap = new ConcurrentHashMap<Long, EventHandler>();
    private final StripedExecutor eventExecutor;

    public ClientListenerServiceImpl(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        this.client = client;
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.invocationService = client.getInvocationService();
        this.serializationService = client.getSerializationService();
        this.eventExecutor = new StripedExecutor(this.logger, client.getName() + ".event", client.getThreadGroup(), eventThreadCount, eventQueueCapacity);
    }

    public void addEventHandler(long callId, EventHandler handler) {
        this.eventHandlerMap.put(callId, handler);
    }

    protected void removeEventHandler(long callId) {
        this.eventHandlerMap.remove(callId);
    }

    protected EventHandler getEventHandler(long callId) {
        return (EventHandler)this.eventHandlerMap.get(callId);
    }

    public void handleEventPacket(Packet packet) {
        try {
            this.eventExecutor.execute((Runnable)((Object)new ClientEventProcessor(packet)));
        }
        catch (RejectedExecutionException e) {
            this.logger.log(Level.WARNING, " event packet could not be handled ", (Throwable)e);
        }
    }

    public void start() {
    }

    public void shutdown() {
        this.eventExecutor.shutdown();
    }

    public StripedExecutor getEventExecutor() {
        return this.eventExecutor;
    }

    public abstract Collection<ClientEventRegistration> getActiveRegistrations(String var1);

    private final class ClientEventProcessor
    implements StripedRunnable {
        private final Packet packet;

        private ClientEventProcessor(Packet packet) {
            this.packet = packet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ClientConnection conn = (ClientConnection)this.packet.getConn();
            try {
                ClientResponse clientResponse = (ClientResponse)ClientListenerServiceImpl.this.serializationService.toObject((Object)this.packet);
                long callId = clientResponse.getCallId();
                Data response = clientResponse.getResponse();
                this.handleEvent(response, callId, conn);
            }
            finally {
                conn.decrementPendingPacketCount();
            }
        }

        private void handleEvent(Data event, long callId, ClientConnection conn) {
            Object eventObject = ClientListenerServiceImpl.this.serializationService.toObject((Object)event);
            EventHandler eventHandler = (EventHandler)ClientListenerServiceImpl.this.eventHandlerMap.get(callId);
            if (eventHandler == null) {
                ClientListenerServiceImpl.this.logger.warning("No eventHandler for callId: " + callId + ", event: " + eventObject + ", conn: " + conn);
                return;
            }
            eventHandler.handle(eventObject);
        }

        public int getKey() {
            return this.packet.getPartitionId();
        }
    }
}

