/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.concurrent.atomiclong.client.AddAndGetRequest;
import com.hazelcast.concurrent.atomiclong.client.AlterAndGetRequest;
import com.hazelcast.concurrent.atomiclong.client.AlterRequest;
import com.hazelcast.concurrent.atomiclong.client.ApplyRequest;
import com.hazelcast.concurrent.atomiclong.client.CompareAndSetRequest;
import com.hazelcast.concurrent.atomiclong.client.GetAndAddRequest;
import com.hazelcast.concurrent.atomiclong.client.GetAndAlterRequest;
import com.hazelcast.concurrent.atomiclong.client.GetAndSetRequest;
import com.hazelcast.concurrent.atomiclong.client.SetRequest;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IFunction;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;

public class ClientAtomicLongProxy
extends ClientProxy
implements IAtomicLong {
    private final String name;
    private volatile Data key;

    public ClientAtomicLongProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    public <R> R apply(IFunction<Long, R> function) {
        Preconditions.isNotNull(function, (String)"function");
        return (R)this.invoke((ClientRequest)new ApplyRequest(this.name, this.toData(function)));
    }

    public void alter(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, (String)"function");
        this.invoke((ClientRequest)new AlterRequest(this.name, this.toData(function)));
    }

    public long alterAndGet(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, (String)"function");
        return (Long)this.invoke((ClientRequest)new AlterAndGetRequest(this.name, this.toData(function)));
    }

    public long getAndAlter(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, (String)"function");
        return (Long)this.invoke((ClientRequest)new GetAndAlterRequest(this.name, this.toData(function)));
    }

    public long addAndGet(long delta) {
        AddAndGetRequest request = new AddAndGetRequest(this.name, delta);
        Long result = (Long)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean compareAndSet(long expect, long update) {
        CompareAndSetRequest request = new CompareAndSetRequest(this.name, expect, update);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public long decrementAndGet() {
        return this.addAndGet(-1L);
    }

    public long get() {
        return this.getAndAdd(0L);
    }

    public long getAndAdd(long delta) {
        GetAndAddRequest request = new GetAndAddRequest(this.name, delta);
        Long result = (Long)this.invoke((ClientRequest)request);
        return result;
    }

    public long getAndSet(long newValue) {
        GetAndSetRequest request = new GetAndSetRequest(this.name, newValue);
        Long result = (Long)this.invoke((ClientRequest)request);
        return result;
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    public void set(long newValue) {
        SetRequest request = new SetRequest(this.name, newValue);
        this.invoke((ClientRequest)request);
    }

    @Override
    protected <T> T invoke(ClientRequest req) {
        return super.invoke(req, this.getKey());
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.toData(this.name);
        }
        return this.key;
    }

    public String toString() {
        return "IAtomicLong{name='" + this.name + '\'' + '}';
    }
}

