/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public class DiscoveryAddressProvider
implements AddressProvider {
    private static final ILogger LOGGER = Logger.getLogger(DiscoveryAddressProvider.class);
    private final DiscoveryService discoveryService;

    public DiscoveryAddressProvider(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    @Override
    public Collection<InetSocketAddress> loadAddresses() {
        ArrayList<InetSocketAddress> possibleMembers = new ArrayList<InetSocketAddress>();
        for (DiscoveryNode discoveryNode : this.discoveryService.discoverNodes()) {
            Address discoveredAddress = discoveryNode.getPrivateAddress();
            try {
                possibleMembers.add(discoveredAddress.getInetSocketAddress());
            }
            catch (UnknownHostException e) {
                LOGGER.log(Level.WARNING, "Unresolvable host exception: " + discoveredAddress, (Throwable)e);
            }
        }
        return possibleMembers;
    }
}

