/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientProperties;
import com.hazelcast.client.config.ClientProperty;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class ClientInvocation
implements Runnable,
ExecutionCallback {
    public static final long RETRY_WAIT_TIME_IN_SECONDS = 1L;
    private static final int UNASSIGNED_PARTITION = -1;
    private static final ILogger LOGGER = Logger.getLogger(ClientInvocation.class);
    private final LifecycleService lifecycleService;
    private final ClientInvocationService invocationService;
    private final ClientExecutionService executionService;
    private final ClientRequest request;
    private final EventHandler handler;
    private final ClientInvocationFuture clientInvocationFuture;
    private final int heartBeatInterval;
    private final Address address;
    private final int partitionId;
    private final Connection connection;
    private boolean urgent;
    private long retryTimeoutPointInMillis;
    private volatile ClientConnection sendConnection;

    private ClientInvocation(HazelcastClientInstanceImpl client, EventHandler handler, ClientRequest request, int partitionId, Address address, Connection connection) {
        this.lifecycleService = client.getLifecycleService();
        this.invocationService = client.getInvocationService();
        this.executionService = client.getClientExecutionService();
        this.handler = handler;
        this.request = request;
        this.partitionId = partitionId;
        this.address = address;
        this.connection = connection;
        ClientProperties clientProperties = client.getClientProperties();
        long waitTime = clientProperties.getMillis(ClientProperty.INVOCATION_TIMEOUT_SECONDS);
        long waitTimeResolved = waitTime > 0L ? waitTime : (long)Integer.parseInt(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getDefaultValue());
        this.retryTimeoutPointInMillis = System.currentTimeMillis() + waitTimeResolved;
        this.clientInvocationFuture = new ClientInvocationFuture(this, client, request);
        int interval = clientProperties.getInteger(ClientProperty.HEARTBEAT_INTERVAL);
        this.heartBeatInterval = interval > 0 ? interval : Integer.parseInt(ClientProperty.HEARTBEAT_INTERVAL.getDefaultValue());
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, EventHandler handler, ClientRequest request) {
        this(client, handler, request, -1, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, EventHandler handler, ClientRequest request, int partitionId) {
        this(client, handler, request, partitionId, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, EventHandler handler, ClientRequest request, Address address) {
        this(client, handler, request, -1, address, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, EventHandler handler, ClientRequest request, Connection connection) {
        this(client, handler, request, -1, null, connection);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientRequest request) {
        this(client, null, request);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientRequest request, int partitionId) {
        this(client, null, request, partitionId);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientRequest request, Address address) {
        this(client, null, request, address);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientRequest request, Connection connection) {
        this(client, null, request, connection);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ClientRequest getRequest() {
        return this.request;
    }

    public EventHandler getEventHandler() {
        return this.handler;
    }

    public ClientInvocationFuture invoke() {
        if (this.request == null) {
            throw new IllegalStateException("Request can not be null");
        }
        try {
            this.invokeOnSelection();
        }
        catch (Exception e) {
            if (e instanceof HazelcastOverloadException) {
                throw (HazelcastOverloadException)e;
            }
            this.notify(e);
        }
        return this.clientInvocationFuture;
    }

    public ClientInvocationFuture invokeUrgent() {
        this.urgent = true;
        return this.invoke();
    }

    private void invokeOnSelection() throws IOException {
        if (this.isBindToSingleConnection()) {
            this.invocationService.invokeOnConnection(this, (ClientConnection)this.connection);
        } else if (this.partitionId != -1) {
            this.invocationService.invokeOnPartitionOwner(this, this.partitionId);
        } else if (this.address != null) {
            this.invocationService.invokeOnTarget(this, this.address);
        } else {
            this.invocationService.invokeOnRandomTarget(this);
        }
    }

    @Override
    public void run() {
        try {
            this.invoke();
        }
        catch (Throwable e) {
            this.clientInvocationFuture.setResponse(e);
        }
    }

    public void notify(Object response) {
        if (response == null) {
            throw new IllegalArgumentException("response can't be null");
        }
        if (!(response instanceof Exception)) {
            this.clientInvocationFuture.setResponse(response);
            return;
        }
        this.notifyException((Exception)response);
    }

    private void notifyException(Exception exception) {
        if (!this.lifecycleService.isRunning()) {
            this.clientInvocationFuture.setResponse(new HazelcastClientNotActiveException(exception.getMessage()));
            return;
        }
        if (ClientInvocation.isRetryable(exception) && this.handleRetry()) {
            return;
        }
        if (exception instanceof RetryableHazelcastException && (this.request instanceof RetryableRequest || this.invocationService.isRedoOperation()) && this.handleRetry()) {
            return;
        }
        this.clientInvocationFuture.setResponse(exception);
    }

    private boolean handleRetry() {
        if (this.isBindToSingleConnection()) {
            return false;
        }
        if (System.currentTimeMillis() > this.retryTimeoutPointInMillis) {
            return false;
        }
        try {
            this.rescheduleInvocation();
        }
        catch (RejectedExecutionException e) {
            if (LOGGER.isFinestEnabled()) {
                LOGGER.finest("Retry could not be scheduled ", (Throwable)e);
            }
            this.notifyException(e);
        }
        return true;
    }

    private void rescheduleInvocation() {
        ClientExecutionServiceImpl executionServiceImpl = (ClientExecutionServiceImpl)this.executionService;
        executionServiceImpl.schedule(this, 1L, TimeUnit.SECONDS, this);
    }

    private boolean isBindToSingleConnection() {
        return this.connection != null;
    }

    boolean isConnectionHealthy(long elapsed) {
        if (elapsed >= (long)this.heartBeatInterval) {
            if (this.sendConnection != null) {
                return this.sendConnection.isHeartBeating();
            }
            return true;
        }
        return true;
    }

    public int getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public boolean isUrgent() {
        return this.urgent;
    }

    public void setSendConnection(ClientConnection connection) {
        this.sendConnection = connection;
    }

    public ClientConnection getSendConnectionOrWait() throws InterruptedException {
        while (this.sendConnection == null && !this.clientInvocationFuture.isDone()) {
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return this.sendConnection;
    }

    public ClientConnection getSendConnection() {
        return this.sendConnection;
    }

    public static boolean isRetryable(Throwable t) {
        return t instanceof IOException || t instanceof HazelcastInstanceNotActiveException || t instanceof AuthenticationException;
    }

    public void onResponse(Object response) {
    }

    public void onFailure(Throwable t) {
        if (LOGGER.isFinestEnabled()) {
            LOGGER.finest("Failure during retry ", t);
        }
        this.clientInvocationFuture.setResponse(t);
    }
}

