/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMultiMapStats;
import com.hazelcast.multimap.impl.ValueCollectionFactory;
import com.hazelcast.multimap.impl.client.AddEntryListenerRequest;
import com.hazelcast.multimap.impl.client.ClearRequest;
import com.hazelcast.multimap.impl.client.ContainsRequest;
import com.hazelcast.multimap.impl.client.CountRequest;
import com.hazelcast.multimap.impl.client.EntrySetRequest;
import com.hazelcast.multimap.impl.client.GetAllRequest;
import com.hazelcast.multimap.impl.client.KeyBasedContainsRequest;
import com.hazelcast.multimap.impl.client.KeySetRequest;
import com.hazelcast.multimap.impl.client.MultiMapIsLockedRequest;
import com.hazelcast.multimap.impl.client.MultiMapLockRequest;
import com.hazelcast.multimap.impl.client.MultiMapUnlockRequest;
import com.hazelcast.multimap.impl.client.PortableEntrySetResponse;
import com.hazelcast.multimap.impl.client.PutRequest;
import com.hazelcast.multimap.impl.client.RemoveAllRequest;
import com.hazelcast.multimap.impl.client.RemoveEntryListenerRequest;
import com.hazelcast.multimap.impl.client.RemoveRequest;
import com.hazelcast.multimap.impl.client.SizeRequest;
import com.hazelcast.multimap.impl.client.ValuesRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.spi.impl.PortableEntryEvent;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientMultiMapProxy<K, V>
extends ClientProxy
implements MultiMap<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private final String name;

    public ClientMultiMapProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    public boolean put(K key, V value) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        PutRequest request = new PutRequest(this.name, keyData, valueData, -1, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public Collection<V> get(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        GetAllRequest request = new GetAllRequest(this.name, keyData, ThreadUtil.getThreadId());
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request, keyData);
        return this.toObjectCollection(result);
    }

    public boolean remove(Object key, Object value) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        RemoveRequest request = new RemoveRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public Collection<V> remove(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        RemoveAllRequest request = new RemoveAllRequest(this.name, keyData, ThreadUtil.getThreadId());
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request, keyData);
        return this.toObjectCollection(result);
    }

    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    public Set<K> keySet() {
        KeySetRequest request = new KeySetRequest(this.name);
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request);
        return (Set)this.toObjectCollection(result);
    }

    public Collection<V> values() {
        ValuesRequest request = new ValuesRequest(this.name);
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request);
        return this.toObjectCollection(result);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetRequest request = new EntrySetRequest(this.name);
        PortableEntrySetResponse result = (PortableEntrySetResponse)this.invoke((ClientRequest)request);
        Set dataEntrySet = result.getEntrySet();
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>(dataEntrySet.size());
        for (Map.Entry entry : dataEntrySet) {
            Object key = this.toObject((Data)entry.getKey());
            Object val = this.toObject((Data)entry.getValue());
            entrySet.add(new AbstractMap.SimpleEntry(key, val));
        }
        return entrySet;
    }

    public boolean containsKey(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        KeyBasedContainsRequest request = new KeyBasedContainsRequest(this.name, keyData, null, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public boolean containsValue(Object value) {
        Preconditions.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        ContainsRequest request = new ContainsRequest(this.name, valueData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean containsEntry(K key, V value) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        KeyBasedContainsRequest request = new KeyBasedContainsRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public int size() {
        SizeRequest request = new SizeRequest(this.name);
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public void clear() {
        ClearRequest request = new ClearRequest(this.name);
        this.invoke((ClientRequest)request);
    }

    public int valueCount(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        CountRequest request = new CountRequest(this.name, keyData, ThreadUtil.getThreadId());
        Integer result = (Integer)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public String addLocalEntryListener(EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        Preconditions.isNotNull(listener, (String)"listener");
        AddEntryListenerRequest addRequest = new AddEntryListenerRequest(this.name, null, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener);
        RemoveEntryListenerRequest removeRequest = new RemoveEntryListenerRequest(this.name);
        return this.registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, handler);
    }

    public boolean removeEntryListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        AddEntryListenerRequest addRequest = new AddEntryListenerRequest(this.name, keyData, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener);
        RemoveEntryListenerRequest removeRequest = new RemoveEntryListenerRequest(this.name);
        return this.registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, handler);
    }

    public void lock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MultiMapLockRequest request = new MultiMapLockRequest(keyData, ThreadUtil.getThreadId(), this.name);
        this.invoke((ClientRequest)request, keyData);
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkPositive((long)leaseTime, (String)"leaseTime should be positive");
        Data keyData = this.toData(key);
        MultiMapLockRequest request = new MultiMapLockRequest(keyData, ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), -1L, this.name);
        this.invoke((ClientRequest)request, keyData);
    }

    public boolean isLocked(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MultiMapIsLockedRequest request = new MultiMapIsLockedRequest(keyData, this.name);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public boolean tryLock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        return this.tryLock(key, time, timeunit, -1L, null);
    }

    public boolean tryLock(K key, long timeout, TimeUnit timeunit, long leaseTime, TimeUnit leaseTimeunit) throws InterruptedException {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        long timeoutInMillis = this.getTimeInMillis(timeout, timeunit);
        long leaseTimeInMillis = this.getTimeInMillis(leaseTime, leaseTimeunit);
        long threadId = ThreadUtil.getThreadId();
        MultiMapLockRequest request = new MultiMapLockRequest(keyData, threadId, leaseTimeInMillis, timeoutInMillis, this.name);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public void unlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MultiMapUnlockRequest request = new MultiMapUnlockRequest(keyData, ThreadUtil.getThreadId(), this.name);
        this.invoke((ClientRequest)request, keyData);
    }

    public void forceUnlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MultiMapUnlockRequest request = new MultiMapUnlockRequest(keyData, ThreadUtil.getThreadId(), true, this.name);
        this.invoke((ClientRequest)request, keyData);
    }

    public LocalMultiMapStats getLocalMultiMapStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getContext().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-multimap-" + this.getName());
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            Preconditions.isNotNull((Object)jobTracker, (String)"jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMultiMap((MultiMap)this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory != null ? mappingJob.combiner(combinerFactory).reducer(reducerFactory) : mappingJob.reducer(reducerFactory);
            JobCompletableFuture future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException((Throwable)e);
        }
    }

    @Override
    protected void onDestroy() {
    }

    private Collection toObjectCollection(PortableCollection result) {
        Collection resultCollection = result.getCollection();
        Collection newCollection = ValueCollectionFactory.createCollection((Collection)resultCollection);
        for (Data data : resultCollection) {
            newCollection.add(this.toObject(data));
        }
        return newCollection;
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<PortableEntryEvent> createHandler(final EntryListener<K, V> listener) {
        return new EventHandler<PortableEntryEvent>(){

            @Override
            public void handle(PortableEntryEvent event) {
                Member member = ClientMultiMapProxy.this.getContext().getClusterService().getMember(event.getUuid());
                switch (event.getEventType()) {
                    case ADDED: {
                        listener.entryAdded(this.createEntryEvent(event, member));
                        break;
                    }
                    case REMOVED: {
                        listener.entryRemoved(this.createEntryEvent(event, member));
                        break;
                    }
                    case CLEAR_ALL: {
                        listener.mapCleared(this.createMapEvent(event, member));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Not a known event type " + event.getEventType());
                    }
                }
            }

            private MapEvent createMapEvent(PortableEntryEvent event, Member member) {
                return new MapEvent((Object)ClientMultiMapProxy.this.name, member, event.getEventType().getType(), event.getNumberOfAffectedEntries());
            }

            private EntryEvent<K, V> createEntryEvent(PortableEntryEvent event, Member member) {
                EntryEventType eventType = event.getEventType();
                Data keyData = event.getKey();
                Data valueData = event.getValue();
                Data oldValueData = event.getOldValue();
                Data mergingValueData = event.getMergingValue();
                return new DataAwareEntryEvent(member, eventType.getType(), ClientMultiMapProxy.this.name, keyData, valueData, oldValueData, mergingValueData, ClientMultiMapProxy.this.getContext().getSerializationService());
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
    }

    public String toString() {
        return "MultiMap{name='" + this.getName() + '\'' + '}';
    }
}

