/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.CacheClearResponse;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheSyncListenerCompleter;
import com.hazelcast.cache.impl.client.CacheAddInvalidationListenerRequest;
import com.hazelcast.cache.impl.client.CacheBatchInvalidationMessage;
import com.hazelcast.cache.impl.client.CacheClearRequest;
import com.hazelcast.cache.impl.client.CacheGetAndRemoveRequest;
import com.hazelcast.cache.impl.client.CacheGetAndReplaceRequest;
import com.hazelcast.cache.impl.client.CacheInvalidationMessage;
import com.hazelcast.cache.impl.client.CachePutIfAbsentRequest;
import com.hazelcast.cache.impl.client.CachePutRequest;
import com.hazelcast.cache.impl.client.CacheRemoveInvalidationListenerRequest;
import com.hazelcast.cache.impl.client.CacheRemoveRequest;
import com.hazelcast.cache.impl.client.CacheReplaceRequest;
import com.hazelcast.cache.impl.client.CacheSingleInvalidationMessage;
import com.hazelcast.cache.impl.client.CompletionAwareCacheRequest;
import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.cache.impl.nearcache.NearCacheContext;
import com.hazelcast.cache.impl.nearcache.NearCacheExecutor;
import com.hazelcast.cache.impl.nearcache.NearCacheManager;
import com.hazelcast.client.cache.impl.AbstractClientCacheProxyBase;
import com.hazelcast.client.cache.impl.ClientCacheStatisticsImpl;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.CompletedFuture;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractClientInternalCacheProxy<K, V>
extends AbstractClientCacheProxyBase<K, V>
implements CacheSyncListenerCompleter {
    private static final long MAX_COMPLETION_LATCH_WAIT_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final long COMPLETION_LATCH_WAIT_TIME_STEP = TimeUnit.SECONDS.toMillis(1L);
    protected final HazelcastClientCacheManager cacheManager;
    protected final NearCacheManager nearCacheManager;
    protected NearCache<Data, Object> nearCache;
    protected String nearCacheMembershipRegistrationId;
    protected final ClientCacheStatisticsImpl statistics;
    protected final boolean statisticsEnabled;
    protected boolean cacheOnUpdate;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> asyncListenerRegistrations;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> syncListenerRegistrations;
    private final ConcurrentMap<Integer, CountDownLatch> syncLocks;
    private final AtomicInteger completionIdCounter = new AtomicInteger();

    protected AbstractClientInternalCacheProxy(CacheConfig cacheConfig, ClientContext clientContext, HazelcastClientCacheManager cacheManager) {
        super(cacheConfig, clientContext);
        this.cacheManager = cacheManager;
        this.nearCacheManager = clientContext.getNearCacheManager();
        this.asyncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncLocks = new ConcurrentHashMap<Integer, CountDownLatch>();
        this.initNearCache();
        this.statistics = this.nearCache != null ? new ClientCacheStatisticsImpl(System.currentTimeMillis(), this.nearCache.getNearCacheStats()) : new ClientCacheStatisticsImpl(System.currentTimeMillis());
        this.statisticsEnabled = cacheConfig.isStatisticsEnabled();
    }

    private void initNearCache() {
        NearCacheConfig nearCacheConfig = this.clientContext.getClientConfig().getNearCacheConfig(this.name);
        if (nearCacheConfig != null) {
            this.cacheOnUpdate = nearCacheConfig.getLocalUpdatePolicy() == NearCacheConfig.LocalUpdatePolicy.CACHE;
            NearCacheContext nearCacheContext = new NearCacheContext(this.nearCacheManager, this.clientContext.getSerializationService(), this.createNearCacheExecutor(this.clientContext.getExecutionService()));
            this.nearCache = this.nearCacheManager.getOrCreateNearCache(this.nameWithPrefix, nearCacheConfig, nearCacheContext);
            this.registerInvalidationListener();
        }
    }

    private NearCacheExecutor createNearCacheExecutor(ClientExecutionService clientExecutionService) {
        return new ClientNearCacheExecutor(clientExecutionService);
    }

    @Override
    public void postClose() {
        if (this.nearCache != null) {
            this.removeInvalidationListener();
            this.nearCacheManager.clearNearCache(this.nearCache.getName());
        }
        if (this.statisticsEnabled) {
            this.statistics.clear();
        }
    }

    @Override
    protected void postDestroy() {
        if (this.nearCache != null) {
            this.removeInvalidationListener();
            this.nearCacheManager.destroyNearCache(this.nearCache.getName());
        }
        if (this.statisticsEnabled) {
            this.statistics.clear();
        }
        this.cacheManager.removeCache(this.cacheConfig.getName(), false);
    }

    protected <T> ClientInvocationFuture<T> invoke(ClientRequest req, int partitionId, boolean completionOperation) {
        Integer completionId = null;
        if (completionOperation) {
            completionId = this.registerCompletionLatch(1);
            if (req instanceof CompletionAwareCacheRequest) {
                ((CompletionAwareCacheRequest)req).setCompletionId(completionId);
            }
        }
        try {
            HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
            ClientInvocation clientInvocation = new ClientInvocation(client, req, partitionId);
            ClientInvocationFuture f = clientInvocation.invoke();
            f.setResponseDeserialized(true);
            if (completionOperation) {
                this.waitCompletionLatch(completionId, f);
            }
            return f;
        }
        catch (Throwable e) {
            if (e instanceof IllegalStateException) {
                this.close();
            }
            if (completionOperation) {
                this.deregisterCompletionLatch(completionId);
            }
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    protected <T> ClientInvocationFuture<T> invoke(ClientRequest req, Data keyData, boolean completionOperation) {
        int partitionId = this.clientContext.getPartitionService().getPartitionId(keyData);
        return this.invoke(req, partitionId, completionOperation);
    }

    protected <T> T getSafely(Future<T> future) {
        try {
            return future.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow((Throwable)throwable);
        }
    }

    protected <T> ICompletableFuture<T> removeAsyncInternal(K key, V oldValue, boolean hasOldValue, final boolean isGet, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture<T> future;
        final long start = System.nanoTime();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue);
        } else {
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key);
        }
        Data keyData = this.toData(key);
        Data oldValueData = oldValue != null ? this.toData(oldValue) : null;
        InMemoryFormat inMemoryFormat = this.cacheConfig.getInMemoryFormat();
        Object request = isGet ? new CacheGetAndRemoveRequest(this.nameWithPrefix, keyData, inMemoryFormat) : new CacheRemoveRequest(this.nameWithPrefix, keyData, oldValueData, inMemoryFormat);
        try {
            future = this.invoke((ClientRequest)request, keyData, withCompletionEvent);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        DelegatingFuture delegatingFuture = new DelegatingFuture(future, this.clientContext.getSerializationService());
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThen((ExecutionCallback)new ExecutionCallback<Object>(){

                public void onResponse(Object responseData) {
                    Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject(responseData);
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnRemove(isGet, start, response);
                }

                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected void handleStatisticsOnRemove(boolean isGet, long start, Object response) {
        if (isGet) {
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (response != null) {
                this.statistics.increaseCacheHits();
                this.statistics.increaseCacheRemovals();
                this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses();
            }
        } else if (Boolean.TRUE.equals(response)) {
            this.statistics.increaseCacheRemovals();
            this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
        }
    }

    protected <T> ICompletableFuture<T> replaceAsyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, final boolean isGet, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture<T> future;
        final long start = System.nanoTime();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, newValue);
        }
        Data keyData = this.toData(key);
        Data oldValueData = oldValue != null ? this.toData(oldValue) : null;
        Data newValueData = newValue != null ? this.toData(newValue) : null;
        InMemoryFormat inMemoryFormat = this.cacheConfig.getInMemoryFormat();
        Object request = isGet ? new CacheGetAndReplaceRequest(this.nameWithPrefix, keyData, newValueData, expiryPolicy, inMemoryFormat) : new CacheReplaceRequest(this.nameWithPrefix, keyData, oldValueData, newValueData, expiryPolicy, inMemoryFormat);
        try {
            future = this.invoke((ClientRequest)request, keyData, withCompletionEvent);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        DelegatingFuture delegatingFuture = new DelegatingFuture(future, this.clientContext.getSerializationService());
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThen((ExecutionCallback)new ExecutionCallback<Object>(){

                public void onResponse(Object responseData) {
                    Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject(responseData);
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnReplace(isGet, start, response);
                }

                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected void handleStatisticsOnReplace(boolean isGet, long start, Object response) {
        if (isGet) {
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (response != null) {
                this.statistics.increaseCacheHits();
                this.statistics.increaseCachePuts();
                this.statistics.addPutTimeNanos(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses();
            }
        } else if (Boolean.TRUE.equals(response)) {
            this.statistics.increaseCacheHits();
            this.statistics.increaseCachePuts();
            this.statistics.addPutTimeNanos(System.nanoTime() - start);
        } else {
            this.statistics.increaseCacheMisses();
        }
    }

    protected Object putInternal(K key, final V value, ExpiryPolicy expiryPolicy, final boolean isGet, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, value);
        final Data keyData = this.toData(key);
        final Data valueData = this.toData(value);
        InMemoryFormat inMemoryFormat = this.cacheConfig.getInMemoryFormat();
        CachePutRequest request = new CachePutRequest(this.nameWithPrefix, keyData, valueData, expiryPolicy, isGet, inMemoryFormat);
        try {
            future = this.invoke((ClientRequest)request, keyData, withCompletionEvent);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        if (!async) {
            try {
                Object response = future.get();
                if (this.nearCache != null) {
                    if (this.cacheOnUpdate) {
                        this.storeInNearCache(keyData, valueData, value);
                    } else {
                        this.invalidateNearCache(keyData);
                    }
                }
                if (this.statisticsEnabled) {
                    this.handleStatisticsOnPut(isGet, start, response);
                }
                return response;
            }
            catch (Throwable e) {
                throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
            }
        }
        if (this.nearCache != null || this.statisticsEnabled) {
            future.andThen((ExecutionCallback)new ExecutionCallback<Object>(){

                public void onResponse(Object responseData) {
                    if (AbstractClientInternalCacheProxy.this.nearCache != null) {
                        if (AbstractClientInternalCacheProxy.this.cacheOnUpdate) {
                            AbstractClientInternalCacheProxy.this.storeInNearCache(keyData, valueData, value);
                        } else {
                            AbstractClientInternalCacheProxy.this.invalidateNearCache(keyData);
                        }
                    }
                    if (AbstractClientInternalCacheProxy.this.statisticsEnabled) {
                        AbstractClientInternalCacheProxy.this.handleStatisticsOnPut(isGet, start, responseData);
                    }
                }

                public void onFailure(Throwable t) {
                }
            });
        }
        return future;
    }

    protected void handleStatisticsOnPut(boolean isGet, long start, Object response) {
        this.statistics.increaseCachePuts();
        this.statistics.addPutTimeNanos(System.nanoTime() - start);
        if (isGet) {
            Object resp = this.clientContext.getSerializationService().toObject(response);
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (resp == null) {
                this.statistics.increaseCacheMisses();
            } else {
                this.statistics.increaseCacheHits();
            }
        }
    }

    protected Object putIfAbsentInternal(K key, final V value, ExpiryPolicy expiryPolicy, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, value);
        final Data keyData = this.toData(key);
        final Data valueData = this.toData(value);
        CachePutIfAbsentRequest request = new CachePutIfAbsentRequest(this.nameWithPrefix, keyData, valueData, expiryPolicy, this.cacheConfig.getInMemoryFormat());
        try {
            future = this.invoke((ClientRequest)request, keyData, withCompletionEvent);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        DelegatingFuture delegatingFuture = new DelegatingFuture(future, this.clientContext.getSerializationService());
        if (!async) {
            try {
                Object response = delegatingFuture.get();
                if (this.nearCache != null) {
                    if (this.cacheOnUpdate) {
                        this.storeInNearCache(keyData, valueData, value);
                    } else {
                        this.invalidateNearCache(keyData);
                    }
                }
                if (this.statisticsEnabled) {
                    this.handleStatisticsOnPutIfAbsent(start, (Boolean)response);
                }
                return response;
            }
            catch (Throwable e) {
                throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
            }
        }
        if (this.nearCache != null || async && this.statisticsEnabled) {
            delegatingFuture.andThen((ExecutionCallback)new ExecutionCallback<Object>(){

                public void onResponse(Object responseData) {
                    if (AbstractClientInternalCacheProxy.this.nearCache != null) {
                        if (AbstractClientInternalCacheProxy.this.cacheOnUpdate) {
                            AbstractClientInternalCacheProxy.this.storeInNearCache(keyData, valueData, value);
                        } else {
                            AbstractClientInternalCacheProxy.this.invalidateNearCache(keyData);
                        }
                    }
                    if (AbstractClientInternalCacheProxy.this.statisticsEnabled) {
                        Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject(responseData);
                        AbstractClientInternalCacheProxy.this.handleStatisticsOnPutIfAbsent(start, (Boolean)response);
                    }
                }

                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected void handleStatisticsOnPutIfAbsent(long start, boolean saved) {
        if (saved) {
            this.statistics.increaseCachePuts();
            this.statistics.addPutTimeNanos(System.nanoTime() - start);
        }
    }

    protected void removeAllInternal(Set<? extends K> keys) {
        HashSet<Data> keysData;
        long start = System.nanoTime();
        if (keys != null) {
            keysData = new HashSet<Data>();
            for (K key : keys) {
                keysData.add(this.toData(key));
            }
        } else {
            keysData = null;
        }
        int partitionCount = this.clientContext.getPartitionService().getPartitionCount();
        int completionId = this.registerCompletionLatch(partitionCount);
        CacheClearRequest request = new CacheClearRequest(this.nameWithPrefix, keysData, true, completionId);
        try {
            Map results = (Map)this.invoke((ClientRequest)request);
            int completionCount = 0;
            for (Object result : results.values()) {
                if (result == null || !(result instanceof CacheClearResponse)) continue;
                Object response = ((CacheClearResponse)result).getResponse();
                if (response instanceof Boolean) {
                    ++completionCount;
                }
                if (!(response instanceof Throwable)) continue;
                throw (Throwable)response;
            }
            this.waitCompletionLatch(completionId, partitionCount - completionCount, null);
            if (this.statisticsEnabled) {
                if (keysData != null) {
                    this.statistics.increaseCacheRemovals(keysData.size());
                    this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
                } else {
                    this.statistics.setLastUpdateTime(System.currentTimeMillis());
                }
            }
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void clearInternal() {
        CacheClearRequest request = new CacheClearRequest(this.nameWithPrefix, null, false, -1);
        try {
            Map results = (Map)this.invoke((ClientRequest)request);
            for (Object result : results.values()) {
                Object response;
                if (result == null || !(result instanceof CacheClearResponse) || !((response = ((CacheClearResponse)result).getResponse()) instanceof Throwable)) continue;
                throw (Throwable)response;
            }
            if (this.statisticsEnabled) {
                this.statistics.setLastUpdateTime(System.currentTimeMillis());
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void storeInNearCache(Data key, Data valueData, V value) {
        if (this.nearCache != null && valueData != null) {
            Object valueToStore = this.nearCache.selectToSave(new Object[]{value, valueData});
            this.nearCache.put((Object)key, valueToStore);
        }
    }

    protected void invalidateNearCache(Data key) {
        if (this.nearCache != null) {
            this.nearCache.remove((Object)key);
        }
    }

    protected void addListenerLocally(String regId, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration.isSynchronous()) {
            this.syncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        } else {
            this.asyncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        }
    }

    protected String removeListenerLocally(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        ConcurrentMap<CacheEntryListenerConfiguration, String> regs = cacheEntryListenerConfiguration.isSynchronous() ? this.syncListenerRegistrations : this.asyncListenerRegistrations;
        return (String)regs.remove(cacheEntryListenerConfiguration);
    }

    protected String getListenerIdLocal(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        ConcurrentMap<CacheEntryListenerConfiguration, String> regs = cacheEntryListenerConfiguration.isSynchronous() ? this.syncListenerRegistrations : this.asyncListenerRegistrations;
        return (String)regs.get(cacheEntryListenerConfiguration);
    }

    private void deregisterAllCacheEntryListener(Collection<String> listenerRegistrations) {
        for (String regId : listenerRegistrations) {
            this.clientContext.getListenerService().deregisterListener(regId);
        }
    }

    @Override
    protected void closeListeners() {
        this.deregisterAllCacheEntryListener(this.syncListenerRegistrations.values());
        this.deregisterAllCacheEntryListener(this.asyncListenerRegistrations.values());
        this.syncListenerRegistrations.clear();
        this.asyncListenerRegistrations.clear();
        this.notifyAndClearSyncListenerLatches();
    }

    private void notifyAndClearSyncListenerLatches() {
        Collection latches = this.syncLocks.values();
        Iterator iterator = latches.iterator();
        while (iterator.hasNext()) {
            CountDownLatch latch = (CountDownLatch)iterator.next();
            iterator.remove();
            while (latch.getCount() > 0L) {
                latch.countDown();
            }
        }
    }

    public void countDownCompletionLatch(int countDownLatchId) {
        if (countDownLatchId != -1) {
            CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId);
            if (countDownLatch == null) {
                return;
            }
            countDownLatch.countDown();
            if (countDownLatch.getCount() == 0L) {
                this.deregisterCompletionLatch(countDownLatchId);
            }
        }
    }

    protected Integer registerCompletionLatch(int count) {
        if (!this.syncListenerRegistrations.isEmpty()) {
            int id = this.completionIdCounter.incrementAndGet();
            int size = this.syncListenerRegistrations.size();
            CountDownLatch countDownLatch = new CountDownLatch(count * size);
            this.syncLocks.put(id, countDownLatch);
            return id;
        }
        return -1;
    }

    protected void deregisterCompletionLatch(Integer countDownLatchId) {
        if (countDownLatchId != -1) {
            this.syncLocks.remove(countDownLatchId);
        }
    }

    protected void waitCompletionLatch(Integer countDownLatchId, ICompletableFuture future) throws ExecutionException {
        CountDownLatch countDownLatch;
        if (countDownLatchId != -1 && (countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId)) != null) {
            this.awaitLatch(countDownLatch, future);
        }
    }

    protected void waitCompletionLatch(Integer countDownLatchId, int offset, ICompletableFuture future) throws ExecutionException {
        CountDownLatch countDownLatch;
        if (countDownLatchId != -1 && (countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId)) != null) {
            for (int i = 0; i < offset; ++i) {
                countDownLatch.countDown();
            }
            this.awaitLatch(countDownLatch, future);
        }
    }

    private void awaitLatch(CountDownLatch countDownLatch, ICompletableFuture future) throws ExecutionException {
        try {
            for (long currentTimeoutMs = MAX_COMPLETION_LATCH_WAIT_TIME; currentTimeoutMs > 0L && !countDownLatch.await(COMPLETION_LATCH_WAIT_TIME_STEP, TimeUnit.MILLISECONDS); currentTimeoutMs -= COMPLETION_LATCH_WAIT_TIME_STEP) {
                Object response;
                if (future != null && future.isDone() && (response = future.get()) instanceof Throwable) {
                    return;
                }
                if (!this.clientContext.isActive()) {
                    throw new HazelcastInstanceNotActiveException();
                }
                if (!this.isClosed()) continue;
                throw new IllegalStateException("Cache (" + this.nameWithPrefix + ") is closed !");
            }
            if (countDownLatch.getCount() > 0L) {
                this.logger.finest("Countdown latch wait timeout after " + MAX_COMPLETION_LATCH_WAIT_TIME + " milliseconds!");
            }
        }
        catch (InterruptedException e) {
            ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    protected EventHandler<Object> createHandler(final CacheEventListenerAdaptor adaptor) {
        return new EventHandler<Object>(){

            @Override
            public void handle(Object event) {
                adaptor.handleEvent(event);
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
    }

    protected ICompletableFuture createCompletedFuture(Object value) {
        return new CompletedFuture(this.clientContext.getSerializationService(), value, this.clientContext.getExecutionService().getAsyncExecutor());
    }

    private void registerInvalidationListener() {
        if (this.nearCache != null && this.nearCache.isInvalidateOnChange()) {
            ClientListenerService listenerService = this.clientContext.getListenerService();
            CacheAddInvalidationListenerRequest addRequest = new CacheAddInvalidationListenerRequest(this.nameWithPrefix);
            Client client = this.clientContext.getClusterService().getLocalClient();
            NearCacheInvalidationHandler handler = new NearCacheInvalidationHandler(client);
            CacheRemoveInvalidationListenerRequest removeRequest = new CacheRemoveInvalidationListenerRequest(this.nameWithPrefix);
            this.nearCacheMembershipRegistrationId = listenerService.registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, handler);
        }
    }

    private void removeInvalidationListener() {
        String registrationId;
        if (this.nearCache != null && this.nearCache.isInvalidateOnChange() && (registrationId = this.nearCacheMembershipRegistrationId) != null) {
            ClientListenerService listenerService = this.clientContext.getListenerService();
            listenerService.deregisterListener(this.nearCacheMembershipRegistrationId);
        }
    }

    private class NearCacheInvalidationHandler
    implements EventHandler<CacheInvalidationMessage> {
        private final Client client;

        private NearCacheInvalidationHandler(Client client) {
            this.client = client;
        }

        @Override
        public void handle(CacheInvalidationMessage message) {
            if (this.client.getUuid().equals(message.getSourceUuid())) {
                return;
            }
            if (message instanceof CacheSingleInvalidationMessage) {
                CacheSingleInvalidationMessage singleInvalidationMessage = (CacheSingleInvalidationMessage)message;
                Data key = singleInvalidationMessage.getKey();
                if (key != null) {
                    AbstractClientInternalCacheProxy.this.nearCache.remove((Object)key);
                } else {
                    AbstractClientInternalCacheProxy.this.nearCache.clear();
                }
            } else if (message instanceof CacheBatchInvalidationMessage) {
                CacheBatchInvalidationMessage batchInvalidationMessage = (CacheBatchInvalidationMessage)message;
                List invalidationMessages = batchInvalidationMessage.getInvalidationMessages();
                if (invalidationMessages != null) {
                    for (CacheSingleInvalidationMessage invalidationMessage : invalidationMessages) {
                        if (this.client.getUuid().equals(invalidationMessage.getSourceUuid())) continue;
                        AbstractClientInternalCacheProxy.this.nearCache.remove((Object)invalidationMessage.getKey());
                    }
                }
            } else {
                AbstractClientInternalCacheProxy.this.logger.finest("Unknown invalidation message: " + message);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
            AbstractClientInternalCacheProxy.this.nearCache.clear();
        }
    }

    private static class ClientNearCacheExecutor
    implements NearCacheExecutor {
        private ClientExecutionService clientExecutionService;

        private ClientNearCacheExecutor(ClientExecutionService clientExecutionService) {
            this.clientExecutionService = clientExecutionService;
        }

        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.clientExecutionService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }
}

