/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.client.CacheDestroyRequest;
import com.hazelcast.cache.impl.client.CacheLoadAllRequest;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheException;
import javax.cache.integration.CompletionListener;

abstract class AbstractClientCacheProxyBase<K, V> {
    static final int TIMEOUT = 10;
    private static final CompletionListener NULL_COMPLETION_LISTENER = new CompletionListener(){

        public void onCompletion() {
        }

        public void onException(Exception e) {
        }
    };
    protected final ILogger logger = Logger.getLogger(this.getClass());
    protected final ClientContext clientContext;
    protected final CacheConfig<K, V> cacheConfig;
    protected final String name;
    protected final String nameWithPrefix;
    private final ConcurrentMap<Future, CompletionListener> loadAllCalls = new ConcurrentHashMap<Future, CompletionListener>();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);

    protected AbstractClientCacheProxyBase(CacheConfig cacheConfig, ClientContext clientContext) {
        this.name = cacheConfig.getName();
        this.nameWithPrefix = cacheConfig.getNameWithPrefix();
        this.cacheConfig = cacheConfig;
        this.clientContext = clientContext;
    }

    protected void ensureOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache operations can not be performed. The cache closed");
        }
    }

    public void close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        this.waitOnGoingLoadAllCallsToFinish();
        this.closeListeners();
        this.postClose();
    }

    protected void postClose() {
    }

    private void waitOnGoingLoadAllCallsToFinish() {
        Iterator iterator = this.loadAllCalls.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Future f = (Future)entry.getKey();
            CompletionListener completionListener = (CompletionListener)entry.getValue();
            try {
                f.get(10L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                this.logger.finest("Error occurred at loadAll operation execution while waiting it to finish on cache close!", t);
                this.handleFailureOnCompletionListener(completionListener, t);
            }
            iterator.remove();
        }
    }

    public void destroy() {
        this.close();
        if (!this.isDestroyed.compareAndSet(false, true)) {
            return;
        }
        this.isClosed.set(true);
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(this.nameWithPrefix);
            CacheDestroyRequest request = new CacheDestroyRequest(this.nameWithPrefix, partitionId);
            ClientInvocation clientInvocation = new ClientInvocation((HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance(), (ClientRequest)request, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            future.get();
            this.postDestroy();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected void postDestroy() {
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public boolean isDestroyed() {
        return this.isDestroyed.get();
    }

    public void open() {
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("Cache is already destroyed! Cannot be reopened");
        }
        if (!this.isClosed.compareAndSet(true, false)) {
            return;
        }
    }

    protected abstract void closeListeners();

    public String getNameWithPrefix() {
        return this.nameWithPrefix;
    }

    protected <T> T toObject(Object data) {
        return (T)this.clientContext.getSerializationService().toObject(data);
    }

    protected Data toData(Object o) {
        return this.clientContext.getSerializationService().toData(o);
    }

    protected <T> T invoke(ClientRequest req) {
        try {
            ClientInvocation clientInvocation = new ClientInvocation((HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance(), req);
            ClientInvocationFuture future = clientInvocation.invoke();
            Object result = future.get();
            return this.toObject(result);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected void submitLoadAllTask(CacheLoadAllRequest request, CompletionListener completionListener) {
        CompletionListener compListener = completionListener != null ? completionListener : NULL_COMPLETION_LISTENER;
        ClientInvocationFuture invocationFuture = null;
        try {
            long start = System.nanoTime();
            ClientInvocationFuture invFuture = invocationFuture = new ClientInvocation((HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance(), (ClientRequest)request).invoke();
            this.loadAllCalls.put((Future)((Object)invFuture), compListener);
            invocationFuture.andThen(new ExecutionCallback<V>((Future)((Object)invFuture), request, start, compListener){
                final /* synthetic */ Future val$invFuture;
                final /* synthetic */ CacheLoadAllRequest val$request;
                final /* synthetic */ long val$start;
                final /* synthetic */ CompletionListener val$compListener;
                {
                    this.val$invFuture = future;
                    this.val$request = cacheLoadAllRequest;
                    this.val$start = l;
                    this.val$compListener = completionListener;
                }

                public void onResponse(V response) {
                    AbstractClientCacheProxyBase.this.loadAllCalls.remove(this.val$invFuture);
                    AbstractClientCacheProxyBase.this.onLoadAll(this.val$request.getKeys(), response, this.val$start, System.nanoTime());
                    this.val$compListener.onCompletion();
                }

                public void onFailure(Throwable t) {
                    AbstractClientCacheProxyBase.this.loadAllCalls.remove(this.val$invFuture);
                    AbstractClientCacheProxyBase.this.handleFailureOnCompletionListener(this.val$compListener, t);
                }
            });
        }
        catch (Throwable t) {
            if (invocationFuture != null) {
                this.loadAllCalls.remove(invocationFuture);
            }
            this.handleFailureOnCompletionListener(compListener, t);
        }
    }

    private void handleFailureOnCompletionListener(CompletionListener completionListener, Throwable t) {
        if (t instanceof Exception) {
            Throwable cause = t.getCause();
            if (t instanceof ExecutionException && cause instanceof CacheException) {
                completionListener.onException((Exception)((CacheException)cause));
            } else {
                completionListener.onException((Exception)t);
            }
        } else if (t instanceof OutOfMemoryError) {
            ExceptionUtil.rethrow((Throwable)t);
        } else {
            completionListener.onException((Exception)new CacheException(t));
        }
    }

    protected void onLoadAll(Set<Data> keys, Object response, long start, long end) {
    }
}

