/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.client.txn.proxy.ClientTxnProxy;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.multimap.impl.client.TxnMultiMapGetRequest;
import com.hazelcast.multimap.impl.client.TxnMultiMapPutRequest;
import com.hazelcast.multimap.impl.client.TxnMultiMapRemoveAllRequest;
import com.hazelcast.multimap.impl.client.TxnMultiMapRemoveRequest;
import com.hazelcast.multimap.impl.client.TxnMultiMapSizeRequest;
import com.hazelcast.multimap.impl.client.TxnMultiMapValueCountRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.transaction.TransactionException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ClientTxnMultiMapProxy<K, V>
extends ClientTxnProxy
implements TransactionalMultiMap<K, V> {
    public ClientTxnMultiMapProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    public boolean put(K key, V value) throws TransactionException {
        TxnMultiMapPutRequest request = new TxnMultiMapPutRequest(this.getName(), this.toData(key), this.toData(value));
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public Collection<V> get(K key) {
        TxnMultiMapGetRequest request = new TxnMultiMapGetRequest(this.getName(), this.toData(key));
        PortableCollection portableCollection = (PortableCollection)this.invoke((ClientRequest)request);
        Collection collection = portableCollection.getCollection();
        AbstractCollection coll = collection instanceof List ? new ArrayList(collection.size()) : new HashSet(collection.size());
        for (Data data : collection) {
            coll.add(this.toObject(data));
        }
        return coll;
    }

    public boolean remove(Object key, Object value) {
        TxnMultiMapRemoveRequest request = new TxnMultiMapRemoveRequest(this.getName(), this.toData(key), this.toData(value));
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public Collection<V> remove(Object key) {
        TxnMultiMapRemoveAllRequest request = new TxnMultiMapRemoveAllRequest(this.getName(), this.toData(key));
        PortableCollection portableCollection = (PortableCollection)this.invoke((ClientRequest)request);
        Collection collection = portableCollection.getCollection();
        AbstractCollection coll = collection instanceof List ? new ArrayList(collection.size()) : new HashSet(collection.size());
        for (Data data : collection) {
            coll.add(this.toObject(data));
        }
        return coll;
    }

    public int valueCount(K key) {
        TxnMultiMapValueCountRequest request = new TxnMultiMapValueCountRequest(this.getName(), this.toData(key));
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public int size() {
        TxnMultiMapSizeRequest request = new TxnMultiMapSizeRequest(this.getName());
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public String getServiceName() {
        return "hz:impl:multiMapService";
    }

    @Override
    void onDestroy() {
    }
}

