/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.client.txn.proxy.ClientTxnProxy;
import com.hazelcast.collection.impl.txnqueue.client.TxnOfferRequest;
import com.hazelcast.collection.impl.txnqueue.client.TxnPeekRequest;
import com.hazelcast.collection.impl.txnqueue.client.TxnPollRequest;
import com.hazelcast.collection.impl.txnqueue.client.TxnSizeRequest;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.nio.serialization.Data;
import java.util.concurrent.TimeUnit;

public class ClientTxnQueueProxy<E>
extends ClientTxnProxy
implements TransactionalQueue<E> {
    public ClientTxnQueueProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    public boolean offer(E e) {
        try {
            return this.offer(e, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e1) {
            return false;
        }
    }

    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Data data = this.toData(e);
        TxnOfferRequest request = new TxnOfferRequest(this.getName(), unit.toMillis(timeout), data);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public E take() throws InterruptedException {
        return this.poll(-1L, TimeUnit.MILLISECONDS);
    }

    public E poll() {
        try {
            return this.poll(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        TxnPollRequest request = new TxnPollRequest(this.getName(), unit.toMillis(timeout));
        return (E)this.invoke((ClientRequest)request);
    }

    public E peek() {
        try {
            return this.peek(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public E peek(long timeout, TimeUnit unit) throws InterruptedException {
        TxnPeekRequest request = new TxnPeekRequest(this.getName(), unit.toMillis(timeout));
        return (E)this.invoke((ClientRequest)request);
    }

    public int size() {
        TxnSizeRequest request = new TxnSizeRequest(this.getName());
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    void onDestroy() {
    }
}

