/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientRegistrationKey;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.nio.Address;
import com.hazelcast.util.UuidUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClientSmartListenerService
extends ClientListenerServiceImpl
implements InitialMembershipListener {
    private final Set<Member> members = new HashSet<Member>();
    private final Map<ClientRegistrationKey, Map<Address, ClientEventRegistration>> registrations = new ConcurrentHashMap<ClientRegistrationKey, Map<Address, ClientEventRegistration>>();
    private final Object listenerRegLock = new Object();
    private String membershipListenerId;

    public ClientSmartListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        super(client, eventThreadCount, eventQueueCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String registerListener(BaseClientAddListenerRequest addRequest, BaseClientRemoveListenerRequest removeRequest, EventHandler handler) {
        addRequest.setLocalOnly();
        String userRegistrationId = UuidUtil.newUnsecureUuidString();
        Object object = this.listenerRegLock;
        synchronized (object) {
            ClientRegistrationKey registrationKey = new ClientRegistrationKey(userRegistrationId, addRequest, removeRequest, handler);
            this.registrations.put(registrationKey, new ConcurrentHashMap());
            try {
                for (Member member : this.members) {
                    this.invoke(registrationKey, member.getAddress());
                }
            }
            catch (Exception e) {
                this.deregisterListener(userRegistrationId);
                throw new HazelcastException("Listener can not be added", (Throwable)e);
            }
            return userRegistrationId;
        }
    }

    private void invoke(ClientRegistrationKey registrationKey, Address address) throws Exception {
        BaseClientAddListenerRequest addRequest = registrationKey.getAddRequest();
        BaseClientRemoveListenerRequest removeRequest = registrationKey.getRemoveRequest();
        EventHandler handler = registrationKey.getHandler();
        handler.beforeListenerRegister();
        ClientInvocation invocation = new ClientInvocation(this.client, handler, (ClientRequest)addRequest, address);
        ClientInvocationFuture future = invocation.invoke();
        String serverRegistrationId = (String)this.serializationService.toObject(future.get());
        handler.onListenerRegister();
        long callId = invocation.getRequest().getCallId();
        ClientEventRegistration registration = new ClientEventRegistration(serverRegistrationId, callId, address, removeRequest);
        Map<Address, ClientEventRegistration> registrationMap = this.registrations.get(registrationKey);
        registrationMap.put(address, registration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deregisterListener(String userRegistrationId) {
        Object object = this.listenerRegLock;
        synchronized (object) {
            ClientRegistrationKey key = new ClientRegistrationKey(userRegistrationId);
            Map<Address, ClientEventRegistration> registrationMap = this.registrations.get(key);
            if (registrationMap == null) {
                return false;
            }
            boolean successful = true;
            for (ClientEventRegistration registration : registrationMap.values()) {
                Address subscriber = registration.getSubscriber();
                try {
                    this.removeEventHandler(registration.getCallId());
                    BaseClientRemoveListenerRequest request = registration.getRemoveRequest();
                    request.setRegistrationId(registration.getServerRegistrationId());
                    ClientInvocationFuture future = new ClientInvocation(this.client, (ClientRequest)request, subscriber).invoke();
                    future.get();
                }
                catch (Exception e) {
                    successful = false;
                    this.logger.warning("Deregistration of listener with id " + userRegistrationId + " has failed to address " + subscriber, (Throwable)e);
                }
            }
            if (successful) {
                this.registrations.remove(key);
            }
            return successful;
        }
    }

    @Override
    public void start() {
        this.membershipListenerId = this.client.getClientClusterService().addMembershipListener((MembershipListener)this);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.membershipListenerId != null) {
            this.client.getClientClusterService().removeMembershipListener(this.membershipListenerId);
        }
    }

    public void memberAdded(final MembershipEvent membershipEvent) {
        this.executionService.executeInternal(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ClientSmartListenerService.this.listenerRegLock;
                synchronized (object) {
                    Member member = membershipEvent.getMember();
                    ClientSmartListenerService.this.members.add(member);
                    for (ClientRegistrationKey registrationKey : ClientSmartListenerService.this.registrations.keySet()) {
                        try {
                            ClientSmartListenerService.this.invoke(registrationKey, member.getAddress());
                        }
                        catch (Exception e) {
                            ClientSmartListenerService.this.logger.warning("Listener " + registrationKey + " can not added to new member " + member);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberRemoved(MembershipEvent membershipEvent) {
        Object object = this.listenerRegLock;
        synchronized (object) {
            Member member = membershipEvent.getMember();
            this.members.remove(member);
            for (Map<Address, ClientEventRegistration> registrationMap : this.registrations.values()) {
                ClientEventRegistration registration = registrationMap.remove(member.getAddress());
                this.removeEventHandler(registration.getCallId());
            }
        }
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(InitialMembershipEvent event) {
        Object object = this.listenerRegLock;
        synchronized (object) {
            this.members.addAll(event.getMembers());
            for (Member member : this.members) {
                for (ClientRegistrationKey registrationKey : this.registrations.keySet()) {
                    try {
                        this.invoke(registrationKey, member.getAddress());
                    }
                    catch (Exception e) {
                        this.logger.warning("Listener " + registrationKey + " can not added to new member " + member);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClientEventRegistration> getActiveRegistrations(String uuid) {
        Object object = this.listenerRegLock;
        synchronized (object) {
            Map<Address, ClientEventRegistration> registrationMap = this.registrations.get(new ClientRegistrationKey(uuid));
            if (registrationMap == null) {
                return Collections.EMPTY_LIST;
            }
            LinkedList<ClientEventRegistration> activeRegistrations = new LinkedList<ClientEventRegistration>();
            for (ClientEventRegistration registration : registrationMap.values()) {
                for (Member member : this.members) {
                    if (!member.getAddress().equals((Object)registration.getSubscriber())) continue;
                    activeRegistrations.add(registration);
                }
            }
            return activeRegistrations;
        }
    }
}

