/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapPartitionLostEvent;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapters;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapListenerFlagOperator;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.impl.client.MapAddEntryListenerRequest;
import com.hazelcast.map.impl.client.MapAddIndexRequest;
import com.hazelcast.map.impl.client.MapAddInterceptorRequest;
import com.hazelcast.map.impl.client.MapAddPartitionLostListenerRequest;
import com.hazelcast.map.impl.client.MapClearNearCacheRequest;
import com.hazelcast.map.impl.client.MapClearRequest;
import com.hazelcast.map.impl.client.MapContainsKeyRequest;
import com.hazelcast.map.impl.client.MapContainsValueRequest;
import com.hazelcast.map.impl.client.MapDeleteRequest;
import com.hazelcast.map.impl.client.MapEvictAllRequest;
import com.hazelcast.map.impl.client.MapEvictRequest;
import com.hazelcast.map.impl.client.MapExecuteOnAllKeysRequest;
import com.hazelcast.map.impl.client.MapExecuteOnKeyRequest;
import com.hazelcast.map.impl.client.MapExecuteOnKeysRequest;
import com.hazelcast.map.impl.client.MapExecuteWithPredicateRequest;
import com.hazelcast.map.impl.client.MapFlushRequest;
import com.hazelcast.map.impl.client.MapGetAllRequest;
import com.hazelcast.map.impl.client.MapGetEntryViewRequest;
import com.hazelcast.map.impl.client.MapGetRequest;
import com.hazelcast.map.impl.client.MapIsEmptyRequest;
import com.hazelcast.map.impl.client.MapIsLockedRequest;
import com.hazelcast.map.impl.client.MapLoadAllKeysRequest;
import com.hazelcast.map.impl.client.MapLoadGivenKeysRequest;
import com.hazelcast.map.impl.client.MapLockRequest;
import com.hazelcast.map.impl.client.MapPutAllRequest;
import com.hazelcast.map.impl.client.MapPutIfAbsentRequest;
import com.hazelcast.map.impl.client.MapPutRequest;
import com.hazelcast.map.impl.client.MapPutTransientRequest;
import com.hazelcast.map.impl.client.MapQueryRequest;
import com.hazelcast.map.impl.client.MapRemoveEntryListenerRequest;
import com.hazelcast.map.impl.client.MapRemoveIfSameRequest;
import com.hazelcast.map.impl.client.MapRemoveInterceptorRequest;
import com.hazelcast.map.impl.client.MapRemovePartitionLostListenerRequest;
import com.hazelcast.map.impl.client.MapRemoveRequest;
import com.hazelcast.map.impl.client.MapReplaceIfSameRequest;
import com.hazelcast.map.impl.client.MapReplaceRequest;
import com.hazelcast.map.impl.client.MapSetRequest;
import com.hazelcast.map.impl.client.MapSizeRequest;
import com.hazelcast.map.impl.client.MapTryPutRequest;
import com.hazelcast.map.impl.client.MapTryRemoveRequest;
import com.hazelcast.map.impl.client.MapUnlockRequest;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.map.impl.query.QueryResultRow;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.spi.impl.PortableEntryEvent;
import com.hazelcast.spi.impl.PortableMapPartitionLostEvent;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.collection.InflatableSet;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ClientMapProxy<K, V>
extends ClientProxy
implements IMap<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    protected static final String NULL_LISTENER_IS_NOT_ALLOWED = "Null listener is not allowed!";
    protected static final String NULL_PREDICATE_IS_NOT_ALLOWED = "Predicate should not be null!";
    protected final String name;

    public ClientMapProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    public boolean containsKey(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.containsKeyInternal(keyData);
    }

    protected boolean containsKeyInternal(Data keyData) {
        MapContainsKeyRequest request = new MapContainsKeyRequest(this.name, keyData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public boolean containsValue(Object value) {
        Preconditions.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        MapContainsValueRequest request = new MapContainsValueRequest(this.name, valueData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public V get(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.getInternal(keyData);
    }

    protected V getInternal(Data keyData) {
        MapGetRequest request = new MapGetRequest(this.name, keyData, ThreadUtil.getThreadId());
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    public V put(K key, V value) {
        return this.put(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public V remove(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.removeInternal(keyData);
    }

    protected V removeInternal(Data keyData) {
        MapRemoveRequest request = new MapRemoveRequest(this.name, keyData, ThreadUtil.getThreadId());
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    public boolean remove(Object key, Object value) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.removeInternal(keyData, valueData);
    }

    protected boolean removeInternal(Data keyData, Data valueData) {
        MapRemoveIfSameRequest request = new MapRemoveIfSameRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public void delete(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        this.deleteInternal(keyData);
    }

    protected void deleteInternal(Data keyData) {
        MapDeleteRequest request = new MapDeleteRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke((ClientRequest)request, keyData);
    }

    public void flush() {
        MapFlushRequest request = new MapFlushRequest(this.name);
        this.invoke((ClientRequest)request);
    }

    public Future<V> getAsync(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.getAsyncInternal(keyData);
    }

    protected ICompletableFuture<V> getAsyncInternal(Data keyData) {
        MapGetRequest request = new MapGetRequest(this.name, keyData, ThreadUtil.getThreadId());
        request.setAsAsync();
        try {
            ICompletableFuture future = this.invokeOnKeyOwner((ClientRequest)request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private ICompletableFuture invokeOnKeyOwner(ClientRequest request, Data keyData) {
        int partitionId = this.getContext().getPartitionService().getPartitionId(keyData);
        ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), request, partitionId);
        return clientInvocation.invoke();
    }

    public Future<V> putAsync(K key, V value) {
        return this.putAsync(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public Future<V> putAsync(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.putAsyncInternal(ttl, timeunit, keyData, valueData);
    }

    protected Future<V> putAsyncInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        MapPutRequest request = new MapPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        request.setAsAsync();
        try {
            ICompletableFuture future = this.invokeOnKeyOwner((ClientRequest)request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Future<V> removeAsync(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.removeAsyncInternal(keyData);
    }

    protected Future<V> removeAsyncInternal(Data keyData) {
        MapRemoveRequest request = new MapRemoveRequest(this.name, keyData, ThreadUtil.getThreadId());
        request.setAsAsync();
        try {
            ICompletableFuture future = this.invokeOnKeyOwner((ClientRequest)request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.tryRemoveInternal(timeout, timeunit, keyData);
    }

    protected Boolean tryRemoveInternal(long timeout, TimeUnit timeunit, Data keyData) {
        MapTryRemoveRequest request = new MapTryRemoveRequest(this.name, keyData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        return (Boolean)this.invoke((ClientRequest)request, keyData);
    }

    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.tryPutInternal(timeout, timeunit, keyData, valueData);
    }

    protected Boolean tryPutInternal(long timeout, TimeUnit timeunit, Data keyData, Data valueData) {
        MapTryPutRequest request = new MapTryPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        return (Boolean)this.invoke((ClientRequest)request, keyData);
    }

    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.putInternal(ttl, timeunit, keyData, valueData);
    }

    protected V putInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        MapPutRequest request = new MapPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    public void putTransient(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.putTransientInternal(ttl, timeunit, keyData, valueData);
    }

    protected void putTransientInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        MapPutTransientRequest request = new MapPutTransientRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        this.invoke((ClientRequest)request);
    }

    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.putIfAbsentInternal(ttl, timeunit, keyData, valueData);
    }

    protected V putIfAbsentInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        MapPutIfAbsentRequest request = new MapPutIfAbsentRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(oldValue, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(newValue, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        return this.replaceIfSameInternal(keyData, oldValueData, newValueData);
    }

    protected Boolean replaceIfSameInternal(Data keyData, Data oldValueData, Data newValueData) {
        MapReplaceIfSameRequest request = new MapReplaceIfSameRequest(this.name, keyData, oldValueData, newValueData, ThreadUtil.getThreadId());
        return (Boolean)this.invoke((ClientRequest)request, keyData);
    }

    public V replace(K key, V value) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.replaceInternal(keyData, valueData);
    }

    protected V replaceInternal(Data keyData, Data valueData) {
        MapReplaceRequest request = new MapReplaceRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    public void set(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.setInternal(ttl, timeunit, keyData, valueData);
    }

    protected void setInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        MapSetRequest request = new MapSetRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        this.invoke((ClientRequest)request, keyData);
    }

    public void lock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke((ClientRequest)request, keyData);
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), -1L);
        this.invoke((ClientRequest)request, keyData);
    }

    public boolean isLocked(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapIsLockedRequest request = new MapIsLockedRequest(this.name, keyData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public boolean tryLock(K key) {
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        return this.tryLock(key, time, timeunit, -1L, null);
    }

    public boolean tryLock(K key, long timeout, TimeUnit timeunit, long leaseTime, TimeUnit leaseTimeunit) throws InterruptedException {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        long timeoutInMillis = this.getTimeInMillis(timeout, timeunit);
        long leaseTimeInMillis = this.getTimeInMillis(leaseTime, leaseTimeunit);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId(), leaseTimeInMillis, timeoutInMillis);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public void unlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapUnlockRequest request = new MapUnlockRequest(this.name, keyData, ThreadUtil.getThreadId(), false);
        this.invoke((ClientRequest)request, keyData);
    }

    public void forceUnlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapUnlockRequest request = new MapUnlockRequest(this.name, keyData, ThreadUtil.getThreadId(), true);
        this.invoke((ClientRequest)request, keyData);
    }

    public String addLocalEntryListener(MapListener listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(EntryListener listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addInterceptor(MapInterceptor interceptor) {
        MapAddInterceptorRequest request = new MapAddInterceptorRequest(this.name, interceptor);
        return (String)this.invoke((ClientRequest)request);
    }

    public void removeInterceptor(String id) {
        MapRemoveInterceptorRequest request = new MapRemoveInterceptorRequest(this.name, id);
        this.invoke((ClientRequest)request);
    }

    public String addEntryListener(MapListener listener, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        return this.addEntryListenerInternal(listener, null, includeValue, null);
    }

    public String addEntryListener(EntryListener listener, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        return this.addEntryListenerInternal(listener, null, includeValue, null);
    }

    public boolean removeEntryListener(String id) {
        return this.deregisterListener(id);
    }

    public String addPartitionLostListener(MapPartitionLostListener listener) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        MapAddPartitionLostListenerRequest addRequest = new MapAddPartitionLostListenerRequest(this.name);
        MapRemovePartitionLostListenerRequest removeRequest = new MapRemovePartitionLostListenerRequest(this.name);
        ClientMapPartitionLostEventHandler handler = new ClientMapPartitionLostEventHandler(listener);
        return this.registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, handler);
    }

    public boolean removePartitionLostListener(String id) {
        return this.deregisterListener(id);
    }

    public String addEntryListener(MapListener listener, K key, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        return this.addEntryListenerInternal(listener, null, includeValue, key);
    }

    public String addEntryListener(EntryListener listener, K key, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        return this.addEntryListenerInternal(listener, null, includeValue, key);
    }

    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        return this.addEntryListenerInternal(listener, predicate, includeValue, key);
    }

    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        return this.addEntryListenerInternal(listener, predicate, includeValue, key);
    }

    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        return this.addEntryListenerInternal(listener, predicate, includeValue, null);
    }

    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull((Object)listener, (String)NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        return this.addEntryListenerInternal(listener, predicate, includeValue, null);
    }

    private String addEntryListenerInternal(Object listener, Predicate<K, V> predicate, boolean includeValue, K key) {
        Data keyData = this.toData(key);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags((ListenerAdapter)listenerAdaptor);
        MapAddEntryListenerRequest addRequest = new MapAddEntryListenerRequest(this.name, keyData, includeValue, predicate, listenerFlags);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listenerAdaptor);
        MapRemoveEntryListenerRequest removeRequest = new MapRemoveEntryListenerRequest(this.name);
        return this.registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, handler);
    }

    public EntryView<K, V> getEntryView(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapGetEntryViewRequest request = new MapGetEntryViewRequest(this.name, keyData, ThreadUtil.getThreadId());
        SimpleEntryView entryView = (SimpleEntryView)this.invoke((ClientRequest)request, keyData);
        if (entryView == null) {
            return null;
        }
        Data value = (Data)entryView.getValue();
        entryView.setKey(key);
        entryView.setValue(this.toObject(value));
        return entryView;
    }

    public boolean evict(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.evictInternal(keyData);
    }

    protected Boolean evictInternal(Data keyData) {
        MapEvictRequest request = new MapEvictRequest(this.name, keyData, ThreadUtil.getThreadId());
        return (Boolean)this.invoke((ClientRequest)request);
    }

    public void evictAll() {
        MapEvictAllRequest request = new MapEvictAllRequest(this.name);
        this.invoke((ClientRequest)request);
        this.clearNearCachesOnLiteMembers();
    }

    public void loadAll(boolean replaceExistingValues) {
        MapLoadAllKeysRequest request = new MapLoadAllKeysRequest(this.name, replaceExistingValues);
        this.invoke((ClientRequest)request);
    }

    public void loadAll(Set<K> keys, boolean replaceExistingValues) {
        Preconditions.checkNotNull(keys, (String)"Parameter keys should not be null.");
        if (keys.isEmpty()) {
            return;
        }
        List<Data> dataKeys = this.convertKeysToData(keys);
        this.loadAllInternal(replaceExistingValues, dataKeys);
    }

    protected void loadAllInternal(boolean replaceExistingValues, List<Data> dataKeys) {
        MapLoadGivenKeysRequest request = new MapLoadGivenKeysRequest(this.name, dataKeys, replaceExistingValues);
        this.invoke((ClientRequest)request);
    }

    private <K> List<Data> convertKeysToData(Set<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Data> dataKeys = new ArrayList<Data>(keys.size());
        for (K key : keys) {
            Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
            Data dataKey = this.toData(key);
            dataKeys.add(dataKey);
        }
        return dataKeys;
    }

    public Map<K, V> getAll(Set<K> keys) {
        if (CollectionUtil.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<Data>> partitionToKeyData = new HashMap<Integer, List<Data>>();
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        for (K key : keys) {
            Data keyData = this.toData(key);
            int partitionId = partitionService.getPartitionId(keyData);
            ArrayList<Data> keyList = (ArrayList<Data>)partitionToKeyData.get(partitionId);
            if (keyList == null) {
                keyList = new ArrayList<Data>();
                partitionToKeyData.put(partitionId, keyList);
            }
            keyList.add(keyData);
        }
        HashMap result = new HashMap();
        this.getAllInternal(partitionToKeyData, result);
        return result;
    }

    protected List<MapEntries> getAllInternal(Map<Integer, List<Data>> partitionToKeyData, Map<K, V> result) {
        ArrayList<ClientInvocationFuture> futures = new ArrayList<ClientInvocationFuture>(partitionToKeyData.size());
        ArrayList<MapEntries> responses = new ArrayList<MapEntries>(partitionToKeyData.size());
        for (Map.Entry<Integer, List<Data>> entry : partitionToKeyData.entrySet()) {
            int partitionId = entry.getKey();
            List<Data> keyList = entry.getValue();
            if (keyList.isEmpty()) continue;
            MapGetAllRequest request = new MapGetAllRequest(this.name, keyList, partitionId);
            futures.add(new ClientInvocation(this.getClient(), (ClientRequest)request, partitionId).invoke());
        }
        for (Future future : futures) {
            try {
                MapEntries entries = (MapEntries)this.toObject(future.get());
                for (Map.Entry entry : entries.entries()) {
                    Object value = this.toObject(entry.getValue());
                    Object key = this.toObject(entry.getKey());
                    result.put(key, value);
                }
                responses.add(entries);
            }
            catch (Exception e) {
                ExceptionUtil.rethrow((Throwable)e);
            }
        }
        return responses;
    }

    public Collection<V> values() {
        return this.valuesInternal(null);
    }

    public Collection<V> values(Predicate predicate) {
        Preconditions.checkNotNull((Object)predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        return this.valuesInternal(predicate);
    }

    private Collection<V> valuesInternal(Predicate predicate) {
        if (predicate instanceof PagingPredicate) {
            return this.valuesForPagingPredicate((PagingPredicate)predicate);
        }
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.VALUE);
        QueryResult result = (QueryResult)this.invoke((ClientRequest)request);
        ArrayList values = new ArrayList(result.size());
        for (QueryResultRow row : result) {
            values.add(this.toObject(row.getValue()));
        }
        return values;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySetInternal(null);
    }

    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        Preconditions.checkNotNull((Object)predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        return this.entrySetInternal(predicate);
    }

    private Set<Map.Entry<K, V>> entrySetInternal(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.ENTRY);
        }
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.ENTRY);
        QueryResult result = (QueryResult)this.invoke((ClientRequest)request);
        if (pagingPredicate == null) {
            SerializationService serializationService = this.getContext().getSerializationService();
            InflatableSet.Builder setBuilder = InflatableSet.newBuilder((int)result.size());
            for (QueryResultRow row : result) {
                LazyMapEntry entry = new LazyMapEntry((Object)row.getKey(), (Object)row.getValue(), serializationService);
                setBuilder.add((Object)entry);
            }
            return setBuilder.build();
        }
        ArrayList resultList = new ArrayList();
        for (QueryResultRow data : result) {
            Object key = this.toObject(data.getKey());
            Object value = this.toObject(data.getValue());
            resultList.add(new AbstractMap.SimpleEntry(key, value));
        }
        return SortingUtil.getSortedQueryResultSet(resultList, (PagingPredicate)pagingPredicate, (IterationType)IterationType.ENTRY);
    }

    public Set<K> keySet() {
        return this.keySetInternal(null);
    }

    public Set<K> keySet(Predicate predicate) {
        Preconditions.checkNotNull((Object)predicate, (String)NULL_PREDICATE_IS_NOT_ALLOWED);
        return this.keySetInternal(predicate);
    }

    private Set<K> keySetInternal(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.KEY);
        }
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.KEY);
        QueryResult result = (QueryResult)this.invoke((ClientRequest)request);
        if (pagingPredicate == null) {
            InflatableSet.Builder setBuilder = InflatableSet.newBuilder((int)result.size());
            for (QueryResultRow row : result) {
                Object key = this.toObject(row.getKey());
                setBuilder.add(key);
            }
            return setBuilder.build();
        }
        ArrayList resultList = new ArrayList(result.size());
        for (QueryResultRow row : result) {
            Object key = this.toObject(row.getKey());
            resultList.add(new AbstractMap.SimpleImmutableEntry(key, null));
        }
        return SortingUtil.getSortedQueryResultSet(resultList, (PagingPredicate)pagingPredicate, (IterationType)IterationType.KEY);
    }

    private Collection<V> valuesForPagingPredicate(PagingPredicate pagingPredicate) {
        pagingPredicate.setIterationType(IterationType.ENTRY);
        MapQueryRequest request = new MapQueryRequest(this.name, (Predicate)pagingPredicate, IterationType.ENTRY);
        QueryResult result = (QueryResult)this.invoke((ClientRequest)request);
        ArrayList resultList = new ArrayList(result.size());
        for (QueryResultRow row : result) {
            Object key = this.toObject(row.getKey());
            Object value = this.toObject(row.getValue());
            resultList.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        return SortingUtil.getSortedQueryResultSet(resultList, (PagingPredicate)pagingPredicate, (IterationType)IterationType.VALUE);
    }

    public Set<K> localKeySet() {
        return this.localKeySet((Predicate)TruePredicate.INSTANCE);
    }

    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public void addIndex(String attribute, boolean ordered) {
        MapAddIndexRequest request = new MapAddIndexRequest(this.name, attribute, ordered);
        this.invoke((ClientRequest)request);
    }

    public LocalMapStats getLocalMapStats() {
        return new LocalMapStatsImpl();
    }

    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.executeOnKeyInternal(keyData, entryProcessor);
    }

    public Object executeOnKeyInternal(Data keyData, EntryProcessor entryProcessor) {
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData, ThreadUtil.getThreadId());
        return this.invoke((ClientRequest)request, keyData);
    }

    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        this.submitToKeyInternal(keyData, entryProcessor, callback);
    }

    public void submitToKeyInternal(Data keyData, EntryProcessor entryProcessor, ExecutionCallback callback) {
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData, ThreadUtil.getThreadId());
        request.setAsSubmitToKey();
        try {
            ICompletableFuture future = this.invokeOnKeyOwner((ClientRequest)request, keyData);
            future.andThen(callback);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Future submitToKey(K key, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.submitToKeyInternal(keyData, entryProcessor);
    }

    public Future submitToKeyInternal(Data keyData, EntryProcessor entryProcessor) {
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData, ThreadUtil.getThreadId());
        request.setAsSubmitToKey();
        try {
            ICompletableFuture future = this.invokeOnKeyOwner((ClientRequest)request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
        MapExecuteOnAllKeysRequest request = new MapExecuteOnAllKeysRequest(this.name, entryProcessor);
        MapEntries mapEntries = (MapEntries)this.invoke((ClientRequest)request);
        return this.prepareResult(mapEntries);
    }

    protected Map<K, Object> prepareResult(MapEntries mapEntries) {
        Map result = MapUtil.createHashMap((int)mapEntries.size());
        for (Map.Entry dataEntry : mapEntries) {
            Data keyData = (Data)dataEntry.getKey();
            Data valueData = (Data)dataEntry.getValue();
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        MapExecuteWithPredicateRequest request = new MapExecuteWithPredicateRequest(this.name, entryProcessor, predicate);
        MapEntries mapEntries = (MapEntries)this.invoke((ClientRequest)request);
        return this.prepareResult(mapEntries);
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getContext().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-map-" + this.getName());
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            Preconditions.isNotNull((Object)jobTracker, (String)"jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMap((IMap)this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory != null ? mappingJob.combiner(combinerFactory).reducer(reducerFactory) : mappingJob.reducer(reducerFactory);
            JobCompletableFuture future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException((Throwable)e);
        }
    }

    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        if (keys == null || keys.size() == 0 || keys.contains(null)) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        HashSet<Data> dataKeys = new HashSet<Data>(keys.size());
        for (K key : keys) {
            dataKeys.add(this.toData(key));
        }
        MapExecuteOnKeysRequest request = new MapExecuteOnKeysRequest(this.name, entryProcessor, dataKeys);
        MapEntries entrySet = (MapEntries)this.invoke((ClientRequest)request);
        return this.prepareResult(entrySet);
    }

    public void set(K key, V value) {
        this.set(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public int size() {
        MapSizeRequest request = new MapSizeRequest(this.name);
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean isEmpty() {
        MapIsEmptyRequest request = new MapIsEmptyRequest(this.name);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        ArrayList futures = new ArrayList(partitionCount);
        MapEntries[] entriesPerPartition = new MapEntries[partitionCount];
        for (Map.Entry<K, V> entry : m.entrySet()) {
            Preconditions.checkNotNull(entry.getKey(), (String)NULL_KEY_IS_NOT_ALLOWED);
            Preconditions.checkNotNull(entry.getValue(), (String)NULL_VALUE_IS_NOT_ALLOWED);
            Data keyData = this.toData(entry.getKey());
            int partitionId = partitionService.getPartitionId(keyData);
            MapEntries entries = entriesPerPartition[partitionId];
            if (entries == null) {
                entriesPerPartition[partitionId] = entries = new MapEntries();
            }
            entries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, this.toData(entry.getValue())));
        }
        this.putAllInternal(futures, entriesPerPartition);
    }

    protected void putAllInternal(List<Future<?>> futures, MapEntries[] entriesPerPartition) {
        for (int partitionId = 0; partitionId < entriesPerPartition.length; ++partitionId) {
            MapEntries entries = entriesPerPartition[partitionId];
            if (entries == null) continue;
            MapPutAllRequest request = new MapPutAllRequest(this.name, entries, partitionId);
            futures.add((Future<?>)((Object)new ClientInvocation(this.getClient(), (ClientRequest)request, partitionId).invoke()));
        }
        try {
            for (Future<?> future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public void clear() {
        MapClearRequest request = new MapClearRequest(this.name);
        this.invoke((ClientRequest)request);
        this.clearNearCachesOnLiteMembers();
    }

    private void clearNearCachesOnLiteMembers() {
        ClientClusterService clusterService = this.getClient().getClientClusterService();
        for (Member member : clusterService.getMembers(MemberSelectors.LITE_MEMBER_SELECTOR)) {
            MapClearNearCacheRequest request = new MapClearNearCacheRequest(this.name, member.getAddress());
            this.invoke((ClientRequest)request, member.getAddress());
        }
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<PortableEntryEvent> createHandler(ListenerAdapter listenerAdapter) {
        return new ClientMapEventHandler(listenerAdapter);
    }

    public String toString() {
        return "IMap{name='" + this.getName() + '\'' + '}';
    }

    private class ClientMapPartitionLostEventHandler
    implements EventHandler<PortableMapPartitionLostEvent> {
        private MapPartitionLostListener listener;

        public ClientMapPartitionLostEventHandler(MapPartitionLostListener listener) {
            this.listener = listener;
        }

        @Override
        public void handle(PortableMapPartitionLostEvent event) {
            Member member = ClientMapProxy.this.getContext().getClusterService().getMember(event.getUuid());
            this.listener.partitionLost(new MapPartitionLostEvent((Object)ClientMapProxy.this.name, member, -1, event.getPartitionId()));
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }

    private class ClientMapEventHandler
    implements EventHandler<PortableEntryEvent> {
        private final ListenerAdapter listenerAdapter;

        public ClientMapEventHandler(ListenerAdapter listenerAdapter) {
            this.listenerAdapter = listenerAdapter;
        }

        @Override
        public void handle(PortableEntryEvent event) {
            Member member = ClientMapProxy.this.getContext().getClusterService().getMember(event.getUuid());
            IMapEvent iMapEvent = this.createIMapEvent(event, member);
            this.listenerAdapter.onEvent((Object)iMapEvent);
        }

        private IMapEvent createIMapEvent(PortableEntryEvent event, Member member) {
            MapEvent iMapEvent;
            switch (event.getEventType()) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: 
                case EXPIRED: 
                case MERGED: {
                    iMapEvent = this.createEntryEvent(event, member);
                    break;
                }
                case EVICT_ALL: 
                case CLEAR_ALL: {
                    iMapEvent = this.createMapEvent(event, member);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + event.getEventType());
                }
            }
            return iMapEvent;
        }

        private MapEvent createMapEvent(PortableEntryEvent event, Member member) {
            return new MapEvent((Object)ClientMapProxy.this.name, member, event.getEventType().getType(), event.getNumberOfAffectedEntries());
        }

        private EntryEvent<K, V> createEntryEvent(PortableEntryEvent event, Member member) {
            EntryEventType eventType = event.getEventType();
            Data keyData = event.getKey();
            Data valueData = event.getValue();
            Data oldValueData = event.getOldValue();
            Data mergingValueData = event.getMergingValue();
            return new DataAwareEntryEvent(member, eventType.getType(), ClientMapProxy.this.name, keyData, valueData, oldValueData, mergingValueData, ClientMapProxy.this.getContext().getSerializationService());
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

