/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.test.archunit;

import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;

public class MatchersUsageCondition
extends ArchCondition<JavaClass> {
    public MatchersUsageCondition() {
        super("Use AssertJ instead of Hamcrest matchers", new Object[0]);
    }

    public void check(JavaClass item, ConditionEvents events) {
        for (JavaMethodCall methodCall : item.getMethodCallsFromSelf()) {
            if (!((AccessTarget.MethodCallTarget)methodCall.getTarget()).getFullName().contains("org.hamcrest")) continue;
            String violatingMethodName = methodCall.getOwner().getFullName();
            events.add(SimpleConditionEvent.violated((Object)item, (String)(violatingMethodName + ":" + methodCall.getLineNumber() + " calls Hamcrest Matcher " + methodCall.getName() + ". You should consider AssertJ matchers.")));
        }
    }

    public static ArchCondition<JavaClass> notUseHamcrestMatchers() {
        return new MatchersUsageCondition();
    }
}

