/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.test.archunit;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.Set;

public class BackupOperationShouldNotImplementMutatingOperation
extends ArchCondition<JavaClass> {
    private static final String MUTATING_OPERATION = "com.hazelcast.spi.impl.operationservice.MutatingOperation";

    BackupOperationShouldNotImplementMutatingOperation() {
        super("not implement com.hazelcast.spi.impl.operationservice.MutatingOperation interface", new Object[0]);
    }

    public void check(JavaClass clazz, ConditionEvents events) {
        Set implementedInterfaces = clazz.getAllRawInterfaces();
        if (implementedInterfaces.stream().anyMatch(i -> i.getName().equals(MUTATING_OPERATION))) {
            events.add(SimpleConditionEvent.violated((Object)clazz, (String)("Backup operation class " + clazz.getName() + " should not implement MutatingOperation interface")));
        }
    }

    static BackupOperationShouldNotImplementMutatingOperation notImplementMutatingOperation() {
        return new BackupOperationShouldNotImplementMutatingOperation();
    }
}

