/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.operation;

import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.operation.QueryAbstractIdAwareOperation;
import java.io.IOException;
import java.util.UUID;

public class QueryCancelOperation
extends QueryAbstractIdAwareOperation {
    private int errorCode;
    private String errorMessage;
    private UUID originatingMemberId;

    public QueryCancelOperation() {
    }

    public QueryCancelOperation(QueryId queryId, int errorCode, String errorMessage, UUID originatingMemberId) {
        super(queryId);
        assert (originatingMemberId != null);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.originatingMemberId = originatingMemberId;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public UUID getOriginatingMemberId() {
        return this.originatingMemberId;
    }

    @Override
    public boolean isSystem() {
        return true;
    }

    @Override
    public int getClassId() {
        return 11;
    }

    @Override
    protected void writeInternal1(ObjectDataOutput out) throws IOException {
        out.writeInt(this.errorCode);
        out.writeString(this.errorMessage);
        UUIDSerializationUtil.writeUUID(out, this.originatingMemberId);
    }

    @Override
    protected void readInternal1(ObjectDataInput in) throws IOException {
        this.errorCode = in.readInt();
        this.errorMessage = in.readString();
        this.originatingMemberId = UUIDSerializationUtil.readUUID(in);
    }
}

