/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical;

import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.impl.calcite.opt.HazelcastConventions;
import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTrait;
import com.hazelcast.sql.impl.calcite.opt.logical.SortLogicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.SortPhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.exchange.SortMergeExchangePhysicalRel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class SortPhysicalRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new SortPhysicalRule();

    private SortPhysicalRule() {
        super(OptUtils.parentChild(SortLogicalRel.class, RelNode.class, HazelcastConventions.LOGICAL), SortPhysicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        SortLogicalRel sort = (SortLogicalRel)call.rel(0);
        RelNode input = sort.getInput();
        Collection<RelNode> transforms = this.getTransforms(sort, input);
        for (RelNode transform : transforms) {
            call.transformTo(transform);
        }
    }

    private Collection<RelNode> getTransforms(SortLogicalRel logicalSort, RelNode convertedInput) {
        ArrayList<RelNode> requiresLocalSortRels = new ArrayList<RelNode>(1);
        ArrayList<RelNode> noLocalSortRels = new ArrayList<RelNode>(1);
        for (RelNode physicalInput : OptUtils.getPhysicalRelsFromSubset(convertedInput)) {
            boolean requiresLocalSort = SortPhysicalRule.requiresLocalSort(logicalSort.getCollation(), physicalInput.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE));
            DistributionTrait physicalInputDist = OptUtils.getDistribution(physicalInput);
            boolean isFullResultOnAll = physicalInputDist.isFullResultSetOnAllParticipants();
            RelNode rel = requiresLocalSort || isFullResultOnAll ? SortPhysicalRule.createLocalSort(logicalSort, physicalInput, requiresLocalSort, isFullResultOnAll) : physicalInput;
            if (!isFullResultOnAll) {
                rel = SortPhysicalRule.createMerge(rel, logicalSort);
            }
            if (requiresLocalSort) {
                requiresLocalSortRels.add(rel);
                continue;
            }
            noLocalSortRels.add(rel);
        }
        if (noLocalSortRels.size() > 0) {
            return noLocalSortRels;
        }
        return requiresLocalSortRels;
    }

    private static boolean requiresLocalSort(RelCollation sortCollation, RelCollation inputCollation) {
        if (sortCollation.getFieldCollations().isEmpty()) {
            return false;
        }
        List<RelFieldCollation> sortFields = sortCollation.getFieldCollations();
        List<RelFieldCollation> inputFields = inputCollation.getFieldCollations();
        if (sortFields.size() <= inputFields.size()) {
            for (int i = 0; i < sortFields.size(); ++i) {
                RelFieldCollation inputField;
                RelFieldCollation sortField = sortFields.get(i);
                if (sortField.equals(inputField = inputFields.get(i))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static SortPhysicalRel createLocalSort(SortLogicalRel logicalSort, RelNode physicalInput, boolean requiresLocalSort, boolean isFullResultOnAll) {
        RelTraitSet traitSet = OptUtils.traitPlus(physicalInput.getTraitSet(), logicalSort.getCollation());
        return new SortPhysicalRel(logicalSort.getCluster(), traitSet, physicalInput, logicalSort.getCollation(), requiresLocalSort, isFullResultOnAll ? logicalSort.offset : null, isFullResultOnAll ? logicalSort.fetch : null);
    }

    private static RelNode createMerge(RelNode physicalInput, SortLogicalRel logicalSort) {
        RelTraitSet traitSet = OptUtils.traitPlus(physicalInput.getTraitSet(), logicalSort.getCollation(), OptUtils.getDistributionDef(physicalInput).getTraitRoot());
        return new SortMergeExchangePhysicalRel(logicalSort.getCluster(), traitSet, physicalInput, logicalSort.getCollation(), logicalSort.fetch, logicalSort.offset);
    }
}

