/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.type;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFamily;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import com.hazelcast.org.apache.calcite.sql.type.AbstractSqlType;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;

public class MultisetSqlType
extends AbstractSqlType {
    private final RelDataType elementType;

    public MultisetSqlType(RelDataType elementType, boolean isNullable) {
        super(SqlTypeName.MULTISET, isNullable, null);
        assert (elementType != null);
        this.elementType = elementType;
        this.computeDigest();
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        if (withDetail) {
            sb.append(this.elementType.getFullTypeString());
        } else {
            sb.append(this.elementType.toString());
        }
        sb.append(" MULTISET");
    }

    @Override
    public RelDataType getComponentType() {
        return this.elementType;
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this;
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        return new RelDataTypePrecedenceList(){

            @Override
            public boolean containsType(RelDataType type) {
                return type.getSqlTypeName() == MultisetSqlType.this.getSqlTypeName() && type.getComponentType() != null && MultisetSqlType.this.getComponentType().getPrecedenceList().containsType(type.getComponentType());
            }

            @Override
            public int compareTypePrecedence(RelDataType type1, RelDataType type2) {
                if (!this.containsType(type1)) {
                    throw new IllegalArgumentException("must contain type: " + type1);
                }
                if (!this.containsType(type2)) {
                    throw new IllegalArgumentException("must contain type: " + type2);
                }
                return MultisetSqlType.this.getComponentType().getPrecedenceList().compareTypePrecedence(type1.getComponentType(), type2.getComponentType());
            }
        };
    }
}

