/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.serialization.impl.portable.DefaultPortableReader;
import com.hazelcast.internal.serialization.impl.portable.DefaultPortableWriter;
import com.hazelcast.internal.serialization.impl.portable.MorphingPortableReader;
import com.hazelcast.internal.serialization.impl.portable.PortableContextImpl;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableInternalGenericRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class PortableSerializer
implements StreamSerializer<Object> {
    private final PortableContextImpl context;
    private final Map<Integer, PortableFactory> factories = new HashMap<Integer, PortableFactory>();

    public PortableSerializer(PortableContextImpl context, Map<Integer, ? extends PortableFactory> portableFactories) {
        this.context = context;
        this.factories.putAll(portableFactories);
    }

    @Override
    public int getTypeId() {
        return -1;
    }

    @Override
    public void write(ObjectDataOutput out, Object o) throws IOException {
        if (o instanceof Portable) {
            Portable p = (Portable)o;
            if (!(out instanceof BufferObjectDataOutput)) {
                throw new IllegalArgumentException("ObjectDataOutput must be instance of BufferObjectDataOutput!");
            }
            if (p.getClassId() == 0) {
                throw new IllegalArgumentException("Portable class ID cannot be zero!");
            }
            out.writeInt(p.getFactoryId());
            out.writeInt(p.getClassId());
            this.writeInternal((BufferObjectDataOutput)out, p);
            return;
        }
        if (o instanceof PortableGenericRecord) {
            this.writePortableGenericRecord(out, (PortableGenericRecord)o);
            return;
        }
        throw new IllegalArgumentException("PortableSerializer can only write Portable and PortableGenericRecord");
    }

    void writeInternal(BufferObjectDataOutput out, Portable p) throws IOException {
        ClassDefinition cd = this.context.lookupOrRegisterClassDefinition(p);
        out.writeInt(cd.getVersion());
        DefaultPortableWriter writer = new DefaultPortableWriter(this, out, cd);
        p.writePortable(writer);
        writer.end();
    }

    @Override
    public Object read(ObjectDataInput in) throws IOException {
        if (!(in instanceof BufferObjectDataInput)) {
            throw new IllegalArgumentException("ObjectDataInput must be instance of BufferObjectDataInput!");
        }
        int factoryId = in.readInt();
        int classId = in.readInt();
        BufferObjectDataInput input = (BufferObjectDataInput)in;
        Portable portable = this.createNewPortableInstance(factoryId, classId);
        if (portable != null) {
            return this.readPortable(input, factoryId, classId, portable);
        }
        GenericRecord genericRecord = (GenericRecord)this.readPortableGenericRecord(input, factoryId, classId);
        assert (genericRecord instanceof PortableGenericRecord);
        return genericRecord;
    }

    private Portable readPortable(BufferObjectDataInput in, int factoryId, int classId, Portable portable) throws IOException {
        int writeVersion = in.readInt();
        int readVersion = this.findPortableVersion(factoryId, classId, portable);
        DefaultPortableReader reader = this.createReader(in, factoryId, classId, writeVersion, readVersion);
        portable.readPortable(reader);
        reader.end();
        return portable;
    }

    private int findPortableVersion(int factoryId, int classId, Portable portable) {
        int currentVersion = this.context.getClassVersion(factoryId, classId);
        if (currentVersion < 0 && (currentVersion = SerializationUtil.getPortableVersion(portable, this.context.getVersion())) > 0) {
            this.context.setClassVersion(factoryId, classId, currentVersion);
        }
        return currentVersion;
    }

    private Portable createNewPortableInstance(int factoryId, int classId) {
        PortableFactory portableFactory = this.factories.get(factoryId);
        if (portableFactory == null) {
            return null;
        }
        return portableFactory.create(classId);
    }

    public InternalGenericRecord readAsInternalGenericRecord(ObjectDataInput in) throws IOException {
        int factoryId = in.readInt();
        int classId = in.readInt();
        int version = in.readInt();
        BufferObjectDataInput input = (BufferObjectDataInput)in;
        ClassDefinition cd = this.setupPositionAndDefinition(input, factoryId, classId, version);
        return new PortableInternalGenericRecord(this, input, cd, true);
    }

    DefaultPortableReader createMorphingReader(BufferObjectDataInput in) throws IOException {
        int factoryId = in.readInt();
        int classId = in.readInt();
        int version = in.readInt();
        Portable portable = this.createNewPortableInstance(factoryId, classId);
        int portableVersion = this.findPortableVersion(factoryId, classId, portable);
        return this.createReader(in, factoryId, classId, version, portableVersion);
    }

    public ClassDefinition setupPositionAndDefinition(BufferObjectDataInput in, int factoryId, int classId, int version) throws IOException {
        ClassDefinition cd;
        int effectiveVersion = version;
        if (effectiveVersion < 0) {
            effectiveVersion = this.context.getVersion();
        }
        if ((cd = this.context.lookupClassDefinition(factoryId, classId, effectiveVersion)) == null) {
            int begin = in.position();
            cd = this.context.readClassDefinition(in, factoryId, classId, effectiveVersion);
            in.position(begin);
        }
        return cd;
    }

    public DefaultPortableReader createReader(BufferObjectDataInput in, int factoryId, int classId, int version, int portableVersion) throws IOException {
        ClassDefinition cd = this.setupPositionAndDefinition(in, factoryId, classId, version);
        DefaultPortableReader reader = portableVersion == cd.getVersion() ? new DefaultPortableReader(this, in, cd) : new MorphingPortableReader(this, in, cd);
        return reader;
    }

    @Override
    public void destroy() {
        this.factories.clear();
    }

    private void writePortableGenericRecord(ObjectDataOutput out, PortableGenericRecord record) throws IOException {
        ClassDefinition cd = record.getClassDefinition();
        out.writeInt(cd.getFactoryId());
        out.writeInt(cd.getClassId());
        this.writePortableGenericRecordInternal(out, record);
    }

    void writePortableGenericRecordInternal(ObjectDataOutput out, PortableGenericRecord record) throws IOException {
        ClassDefinition cd = record.getClassDefinition();
        this.context.registerClassDefinition(cd, this.context.shouldCheckClassDefinitionErrors());
        out.writeInt(cd.getVersion());
        BufferObjectDataOutput output = (BufferObjectDataOutput)out;
        DefaultPortableWriter writer = new DefaultPortableWriter(this, output, cd);
        Set<String> fieldNames = cd.getFieldNames();
        block32: for (String fieldName : fieldNames) {
            switch (cd.getFieldType(fieldName)) {
                case PORTABLE: {
                    writer.writeGenericRecord(fieldName, record.getGenericRecord(fieldName));
                    continue block32;
                }
                case BYTE: {
                    writer.writeByte(fieldName, record.getByte(fieldName));
                    continue block32;
                }
                case BOOLEAN: {
                    writer.writeBoolean(fieldName, record.getBoolean(fieldName));
                    continue block32;
                }
                case CHAR: {
                    writer.writeChar(fieldName, record.getChar(fieldName));
                    continue block32;
                }
                case SHORT: {
                    writer.writeShort(fieldName, record.getShort(fieldName));
                    continue block32;
                }
                case INT: {
                    writer.writeInt(fieldName, record.getInt(fieldName));
                    continue block32;
                }
                case LONG: {
                    writer.writeLong(fieldName, record.getLong(fieldName));
                    continue block32;
                }
                case FLOAT: {
                    writer.writeFloat(fieldName, record.getFloat(fieldName));
                    continue block32;
                }
                case DOUBLE: {
                    writer.writeDouble(fieldName, record.getDouble(fieldName));
                    continue block32;
                }
                case UTF: {
                    writer.writeString(fieldName, record.getString(fieldName));
                    continue block32;
                }
                case DECIMAL: {
                    writer.writeDecimal(fieldName, record.getDecimal(fieldName));
                    continue block32;
                }
                case TIME: {
                    writer.writeTime(fieldName, record.getTime(fieldName));
                    continue block32;
                }
                case DATE: {
                    writer.writeDate(fieldName, record.getDate(fieldName));
                    continue block32;
                }
                case TIMESTAMP: {
                    writer.writeTimestamp(fieldName, record.getTimestamp(fieldName));
                    continue block32;
                }
                case TIMESTAMP_WITH_TIMEZONE: {
                    writer.writeTimestampWithTimezone(fieldName, record.getTimestampWithTimezone(fieldName));
                    continue block32;
                }
                case PORTABLE_ARRAY: {
                    writer.writeGenericRecordArray(fieldName, record.getGenericRecordArray(fieldName));
                    continue block32;
                }
                case BYTE_ARRAY: {
                    writer.writeByteArray(fieldName, record.getByteArray(fieldName));
                    continue block32;
                }
                case BOOLEAN_ARRAY: {
                    writer.writeBooleanArray(fieldName, record.getBooleanArray(fieldName));
                    continue block32;
                }
                case CHAR_ARRAY: {
                    writer.writeCharArray(fieldName, record.getCharArray(fieldName));
                    continue block32;
                }
                case SHORT_ARRAY: {
                    writer.writeShortArray(fieldName, record.getShortArray(fieldName));
                    continue block32;
                }
                case INT_ARRAY: {
                    writer.writeIntArray(fieldName, record.getIntArray(fieldName));
                    continue block32;
                }
                case LONG_ARRAY: {
                    writer.writeLongArray(fieldName, record.getLongArray(fieldName));
                    continue block32;
                }
                case FLOAT_ARRAY: {
                    writer.writeFloatArray(fieldName, record.getFloatArray(fieldName));
                    continue block32;
                }
                case DOUBLE_ARRAY: {
                    writer.writeDoubleArray(fieldName, record.getDoubleArray(fieldName));
                    continue block32;
                }
                case UTF_ARRAY: {
                    writer.writeStringArray(fieldName, record.getStringArray(fieldName));
                    continue block32;
                }
                case DECIMAL_ARRAY: {
                    writer.writeDecimalArray(fieldName, record.getDecimalArray(fieldName));
                    continue block32;
                }
                case TIME_ARRAY: {
                    writer.writeTimeArray(fieldName, record.getTimeArray(fieldName));
                    continue block32;
                }
                case DATE_ARRAY: {
                    writer.writeDateArray(fieldName, record.getDateArray(fieldName));
                    continue block32;
                }
                case TIMESTAMP_ARRAY: {
                    writer.writeTimestampArray(fieldName, record.getTimestampArray(fieldName));
                    continue block32;
                }
                case TIMESTAMP_WITH_TIMEZONE_ARRAY: {
                    writer.writeTimestampWithTimezoneArray(fieldName, record.getTimestampWithTimezoneArray(fieldName));
                    continue block32;
                }
            }
            throw new IllegalStateException("Unexpected field type: " + (Object)((Object)cd.getFieldType(fieldName)));
        }
        writer.end();
    }

    <T> T readAsObject(BufferObjectDataInput in, int factoryId, int classId) throws IOException {
        Portable portable = this.createNewPortableInstance(factoryId, classId);
        if (portable == null) {
            throw new HazelcastSerializationException("Could not find PortableFactory for factory-id: " + factoryId + ", class-id:" + classId);
        }
        this.readPortable(in, factoryId, classId, portable);
        ManagedContext managedContext = this.context.getManagedContext();
        return (T)(managedContext != null ? managedContext.initialize(portable) : portable);
    }

    <T> T readAndInitialize(BufferObjectDataInput in, int factoryId, int classId, boolean readGenericLazy) throws IOException {
        if (readGenericLazy) {
            int version = in.readInt();
            ClassDefinition cd = this.setupPositionAndDefinition(in, factoryId, classId, version);
            PortableInternalGenericRecord reader = new PortableInternalGenericRecord(this, in, cd, true);
            return (T)reader;
        }
        return this.readPortableGenericRecord(in, factoryId, classId);
    }

    private <T> T readPortableGenericRecord(BufferObjectDataInput in, int factoryId, int classId) throws IOException {
        int version = in.readInt();
        ClassDefinition cd = this.setupPositionAndDefinition(in, factoryId, classId, version);
        PortableInternalGenericRecord reader = new PortableInternalGenericRecord(this, in, cd, false);
        GenericRecordBuilder genericRecordBuilder = GenericRecordBuilder.portable(cd);
        block32: for (String fieldName : cd.getFieldNames()) {
            switch (cd.getFieldType(fieldName)) {
                case PORTABLE: {
                    genericRecordBuilder.setGenericRecord(fieldName, reader.getGenericRecord(fieldName));
                    continue block32;
                }
                case BYTE: {
                    genericRecordBuilder.setByte(fieldName, reader.getByte(fieldName));
                    continue block32;
                }
                case BOOLEAN: {
                    genericRecordBuilder.setBoolean(fieldName, reader.getBoolean(fieldName));
                    continue block32;
                }
                case CHAR: {
                    genericRecordBuilder.setChar(fieldName, reader.getChar(fieldName));
                    continue block32;
                }
                case SHORT: {
                    genericRecordBuilder.setShort(fieldName, reader.getShort(fieldName));
                    continue block32;
                }
                case INT: {
                    genericRecordBuilder.setInt(fieldName, reader.getInt(fieldName));
                    continue block32;
                }
                case LONG: {
                    genericRecordBuilder.setLong(fieldName, reader.getLong(fieldName));
                    continue block32;
                }
                case FLOAT: {
                    genericRecordBuilder.setFloat(fieldName, reader.getFloat(fieldName));
                    continue block32;
                }
                case DOUBLE: {
                    genericRecordBuilder.setDouble(fieldName, reader.getDouble(fieldName));
                    continue block32;
                }
                case UTF: {
                    genericRecordBuilder.setString(fieldName, reader.getString(fieldName));
                    continue block32;
                }
                case DECIMAL: {
                    genericRecordBuilder.setDecimal(fieldName, reader.getDecimal(fieldName));
                    continue block32;
                }
                case TIME: {
                    genericRecordBuilder.setTime(fieldName, reader.getTime(fieldName));
                    continue block32;
                }
                case DATE: {
                    genericRecordBuilder.setDate(fieldName, reader.getDate(fieldName));
                    continue block32;
                }
                case TIMESTAMP: {
                    genericRecordBuilder.setTimestamp(fieldName, reader.getTimestamp(fieldName));
                    continue block32;
                }
                case TIMESTAMP_WITH_TIMEZONE: {
                    genericRecordBuilder.setTimestampWithTimezone(fieldName, reader.getTimestampWithTimezone(fieldName));
                    continue block32;
                }
                case PORTABLE_ARRAY: {
                    genericRecordBuilder.setGenericRecordArray(fieldName, reader.getGenericRecordArray(fieldName));
                    continue block32;
                }
                case BYTE_ARRAY: {
                    genericRecordBuilder.setByteArray(fieldName, reader.getByteArray(fieldName));
                    continue block32;
                }
                case BOOLEAN_ARRAY: {
                    genericRecordBuilder.setBooleanArray(fieldName, reader.getBooleanArray(fieldName));
                    continue block32;
                }
                case CHAR_ARRAY: {
                    genericRecordBuilder.setCharArray(fieldName, reader.getCharArray(fieldName));
                    continue block32;
                }
                case SHORT_ARRAY: {
                    genericRecordBuilder.setShortArray(fieldName, reader.getShortArray(fieldName));
                    continue block32;
                }
                case INT_ARRAY: {
                    genericRecordBuilder.setIntArray(fieldName, reader.getIntArray(fieldName));
                    continue block32;
                }
                case LONG_ARRAY: {
                    genericRecordBuilder.setLongArray(fieldName, reader.getLongArray(fieldName));
                    continue block32;
                }
                case FLOAT_ARRAY: {
                    genericRecordBuilder.setFloatArray(fieldName, reader.getFloatArray(fieldName));
                    continue block32;
                }
                case DOUBLE_ARRAY: {
                    genericRecordBuilder.setDoubleArray(fieldName, reader.getDoubleArray(fieldName));
                    continue block32;
                }
                case UTF_ARRAY: {
                    genericRecordBuilder.setStringArray(fieldName, reader.getStringArray(fieldName));
                    continue block32;
                }
                case DECIMAL_ARRAY: {
                    genericRecordBuilder.setDecimalArray(fieldName, reader.getDecimalArray(fieldName));
                    continue block32;
                }
                case TIME_ARRAY: {
                    genericRecordBuilder.setTimeArray(fieldName, reader.getTimeArray(fieldName));
                    continue block32;
                }
                case DATE_ARRAY: {
                    genericRecordBuilder.setDateArray(fieldName, reader.getDateArray(fieldName));
                    continue block32;
                }
                case TIMESTAMP_ARRAY: {
                    genericRecordBuilder.setTimestampArray(fieldName, reader.getTimestampArray(fieldName));
                    continue block32;
                }
                case TIMESTAMP_WITH_TIMEZONE_ARRAY: {
                    genericRecordBuilder.setTimestampWithTimezoneArray(fieldName, reader.getTimestampWithTimezoneArray(fieldName));
                    continue block32;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)cd.getFieldType(fieldName)));
        }
        reader.end();
        return (T)genericRecordBuilder.build();
    }
}

