/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.io;

import com.hazelcast.sql.impl.exec.AbstractExec;
import com.hazelcast.sql.impl.exec.IterationResult;
import com.hazelcast.sql.impl.exec.io.InboundBatch;
import com.hazelcast.sql.impl.exec.io.StripedInbox;
import com.hazelcast.sql.impl.exec.sort.MergeSort;
import com.hazelcast.sql.impl.exec.sort.MergeSortSource;
import com.hazelcast.sql.impl.exec.sort.SortKey;
import com.hazelcast.sql.impl.exec.sort.SortKeyComparator;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.row.EmptyRowBatch;
import com.hazelcast.sql.impl.row.ListRowBatch;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.row.RowBatch;
import com.hazelcast.sql.impl.worker.QueryFragmentContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class ReceiveSortMergeExec
extends AbstractExec {
    private final StripedInbox inbox;
    private final int[] columnIndexes;
    private final MergeSort sorter;
    private RowBatch curBatch;

    public ReceiveSortMergeExec(int id, StripedInbox inbox, int[] columnIndexes, boolean[] ascs, Expression fetch, Expression offset) {
        super(id);
        this.inbox = inbox;
        this.columnIndexes = columnIndexes;
        MergeSortSource[] sources = new MergeSortSource[inbox.getStripeCount()];
        for (int i = 0; i < inbox.getStripeCount(); ++i) {
            sources[i] = new Source(i);
        }
        this.sorter = new MergeSort(sources, new SortKeyComparator(ascs), fetch, offset);
    }

    @Override
    protected void setup0(QueryFragmentContext ctx) {
        this.inbox.setup();
        this.sorter.setup(ctx);
    }

    @Override
    public IterationResult advance0() {
        List<Row> rows = this.sorter.nextBatch();
        boolean done = this.sorter.isDone();
        if (rows == null || rows.size() == 0) {
            this.curBatch = EmptyRowBatch.INSTANCE;
            return done ? IterationResult.FETCHED_DONE : IterationResult.WAIT;
        }
        ListRowBatch batch = new ListRowBatch(rows);
        this.curBatch = batch;
        return done ? IterationResult.FETCHED_DONE : IterationResult.FETCHED;
    }

    @Override
    public RowBatch currentBatch0() {
        return this.curBatch;
    }

    private SortKey prepareSortKey(Row row, int stripe) {
        Object[] key = new Object[this.columnIndexes.length];
        for (int i = 0; i < this.columnIndexes.length; ++i) {
            int idx = this.columnIndexes[i];
            key[i] = row.get(idx);
        }
        return new SortKey(key, stripe);
    }

    public MergeSort getMergeSort() {
        return this.sorter;
    }

    private final class Source
    implements MergeSortSource {
        private static final int INDEX_BEFORE = -1;
        private final int index;
        private RowBatch curBatch;
        private int curRowIndex = -1;
        private SortKey curKey;
        private Row curRow;
        private boolean last;

        private Source(int index) {
            this.index = index;
        }

        @Override
        public boolean advance() {
            while (this.noBatch()) {
                if (this.last) {
                    return false;
                }
                InboundBatch batch = ReceiveSortMergeExec.this.inbox.poll(this.index);
                if (batch == null) {
                    return false;
                }
                this.last = batch.isLast();
                RowBatch batch0 = batch.getBatch();
                if (batch0.getRowCount() == 0) continue;
                this.curBatch = batch0;
                this.curRowIndex = 0;
                break;
            }
            assert (this.curRowIndex < this.curBatch.getRowCount());
            this.curRow = this.curBatch.getRow(this.curRowIndex++);
            this.curKey = ReceiveSortMergeExec.this.prepareSortKey(this.curRow, this.index);
            if (this.curRowIndex == this.curBatch.getRowCount()) {
                this.curBatch = null;
                this.curRowIndex = -1;
            }
            return true;
        }

        @Override
        public boolean isDone() {
            return this.noBatch() && this.last;
        }

        @Override
        public SortKey peekKey() {
            return this.curKey;
        }

        @Override
        public Row peekRow() {
            return this.curRow;
        }

        private boolean noBatch() {
            return this.curRowIndex == -1;
        }
    }
}

