/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeComparability;
import com.hazelcast.org.apache.calcite.sql.ExplicitOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlInfixOperator;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserUtil;
import com.hazelcast.org.apache.calcite.sql.type.ComparableOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.InferTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.org.apache.calcite.util.Util;

public class SqlBetweenOperator
extends SqlInfixOperator {
    private static final String[] BETWEEN_NAMES = new String[]{"BETWEEN", "AND"};
    private static final String[] NOT_BETWEEN_NAMES = new String[]{"NOT BETWEEN", "AND"};
    public static final int VALUE_OPERAND = 0;
    public static final int LOWER_OPERAND = 1;
    public static final int UPPER_OPERAND = 2;
    private static final SqlOperandTypeChecker OTC_CUSTOM = new ComparableOperandTypeChecker(3, RelDataTypeComparability.ALL, SqlOperandTypeChecker.Consistency.COMPARE);
    private static final SqlWriter.FrameType FRAME_TYPE = SqlWriter.FrameTypeEnum.create("BETWEEN");
    public final Flag flag;
    private final boolean negated;

    public SqlBetweenOperator(Flag flag, boolean negated) {
        super(negated ? NOT_BETWEEN_NAMES : BETWEEN_NAMES, SqlKind.BETWEEN, 32, null, InferTypes.FIRST_KNOWN, OTC_CUSTOM);
        this.flag = flag;
        this.negated = negated;
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        ExplicitOperatorBinding newOpBinding = new ExplicitOperatorBinding(opBinding, opBinding.collectOperandTypes());
        return ReturnTypes.BOOLEAN_NULLABLE.inferReturnType(newOpBinding);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        Util.discard(operandsCount);
        return "{1} {0} {2} AND {3}";
    }

    @Override
    public String getName() {
        return super.getName() + " " + this.flag.name();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(FRAME_TYPE, "", "");
        ((SqlNode)call.operand(0)).unparse(writer, this.getLeftPrec(), 0);
        writer.sep(super.getName());
        writer.sep(this.flag.name());
        Object lower = call.operand(1);
        Object upper = call.operand(2);
        int lowerPrec = new AndFinder().containsAnd((SqlNode)lower) ? 100 : 0;
        ((SqlNode)lower).unparse(writer, lowerPrec, lowerPrec);
        writer.sep("AND");
        ((SqlNode)upper).unparse(writer, 0, this.getRightPrec());
        writer.endList(frame);
    }

    @Override
    public SqlSpecialOperator.ReduceResult reduceExpr(int opOrdinal, SqlSpecialOperator.TokenSequence list) {
        SqlOperator op = list.op(opOrdinal);
        assert (op == this);
        SqlNode exp1 = SqlParserUtil.toTreeEx(list, opOrdinal + 1, 0, SqlKind.AND);
        if (opOrdinal + 2 >= list.size()) {
            SqlParserPos lastPos = list.pos(list.size() - 1);
            int line = lastPos.getEndLineNum();
            int col = lastPos.getEndColumnNum() + 1;
            SqlParserPos errPos = new SqlParserPos(line, col, line, col);
            throw SqlUtil.newContextException(errPos, Static.RESOURCE.betweenWithoutAnd());
        }
        if (!list.isOp(opOrdinal + 2) || list.op(opOrdinal + 2).getKind() != SqlKind.AND) {
            SqlParserPos errPos = list.pos(opOrdinal + 2);
            throw SqlUtil.newContextException(errPos, Static.RESOURCE.betweenWithoutAnd());
        }
        SqlNode exp2 = SqlParserUtil.toTreeEx(list, opOrdinal + 3, this.getRightPrec(), SqlKind.OTHER);
        SqlNode exp0 = list.node(opOrdinal - 1);
        SqlCall newExp = this.createCall(list.pos(opOrdinal), exp0, exp1, exp2);
        return new SqlSpecialOperator.ReduceResult(opOrdinal - 1, opOrdinal + 4, newExp);
    }

    private static class AndFinder
    extends SqlBasicVisitor<Void> {
        private AndFinder() {
        }

        @Override
        public Void visit(SqlCall call) {
            SqlOperator operator = call.getOperator();
            if (operator == SqlStdOperatorTable.AND) {
                throw Util.FoundOne.NULL;
            }
            return (Void)super.visit(call);
        }

        boolean containsAnd(SqlNode node) {
            try {
                node.accept(this);
                return false;
            }
            catch (Util.FoundOne e) {
                return true;
            }
        }
    }

    public static enum Flag {
        ASYMMETRIC,
        SYMMETRIC;

    }
}

