/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.math;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastFunction;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;

public final class HazelcastAbsFunction
extends HazelcastFunction {
    public static final HazelcastAbsFunction INSTANCE = new HazelcastAbsFunction();

    private HazelcastAbsFunction() {
        super("ABS", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0, new ReplaceUnknownOperandTypeInference(SqlTypeName.BIGINT), SqlFunctionCategory.NUMERIC);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(1);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        TypedOperandChecker checker;
        RelDataType operandType = binding.getOperandType(0);
        if (HazelcastTypeUtils.isNumericIntegerType(operandType)) {
            int bitWidth = ((HazelcastIntegerType)operandType).getBitWidth();
            operandType = HazelcastIntegerType.create(bitWidth + 1, operandType.isNullable());
        }
        if ((checker = TypedOperandChecker.forType(operandType)).isNumeric()) {
            return checker.check(binding, throwOnFailure, 0);
        }
        if (throwOnFailure) {
            throw binding.newValidationSignatureError();
        }
        return false;
    }
}

