/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.splitbrainprotection.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.splitbrainprotection.HeartbeatAware;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionFunction;
import com.hazelcast.splitbrainprotection.impl.AbstractPingAwareSplitBrainProtectionFunction;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RecentlyActiveSplitBrainProtectionFunction
extends AbstractPingAwareSplitBrainProtectionFunction
implements HeartbeatAware,
SplitBrainProtectionFunction,
MembershipListener {
    private final int minimumClusterSize;
    private final int heartbeatToleranceMillis;
    private final ConcurrentMap<Member, Long> latestHeartbeatPerMember = new ConcurrentHashMap<Member, Long>();

    public RecentlyActiveSplitBrainProtectionFunction(int minimumClusterSize, int heartbeatToleranceMillis) {
        this.minimumClusterSize = minimumClusterSize;
        this.heartbeatToleranceMillis = heartbeatToleranceMillis;
    }

    @Override
    public boolean apply(Collection<Member> members) {
        if (members.size() < this.minimumClusterSize) {
            return false;
        }
        int count = 0;
        long now = Clock.currentTimeMillis();
        for (Member member : members) {
            if (!this.isAlivePerIcmp(member)) continue;
            if (member.localMember()) {
                ++count;
                continue;
            }
            Long latestTimestamp = (Long)this.latestHeartbeatPerMember.get(member);
            if (latestTimestamp == null || now - latestTimestamp >= (long)this.heartbeatToleranceMillis) continue;
            ++count;
        }
        return count >= this.minimumClusterSize;
    }

    @Override
    public void onHeartbeat(Member member, long timestamp) {
        this.latestHeartbeatPerMember.put(member, timestamp);
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
        super.memberRemoved(membershipEvent);
        this.latestHeartbeatPerMember.remove(membershipEvent.getMember());
    }

    public int getHeartbeatToleranceMillis() {
        return this.heartbeatToleranceMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecentlyActiveSplitBrainProtectionFunction)) {
            return false;
        }
        RecentlyActiveSplitBrainProtectionFunction that = (RecentlyActiveSplitBrainProtectionFunction)o;
        if (this.minimumClusterSize != that.minimumClusterSize) {
            return false;
        }
        return this.heartbeatToleranceMillis == that.heartbeatToleranceMillis;
    }

    public int hashCode() {
        int result = this.minimumClusterSize;
        result = 31 * result + this.heartbeatToleranceMillis;
        return result;
    }
}

