/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;

public final class Records {
    private static final Map<RecordReaderWriter, RecordReaderWriter> RU_COMPAT_MAP = Records.createAndInitRuCompatMap();

    private Records() {
    }

    private static EnumMap<RecordReaderWriter, RecordReaderWriter> createAndInitRuCompatMap() {
        EnumMap<RecordReaderWriter, RecordReaderWriter> ruCompatMap = new EnumMap<RecordReaderWriter, RecordReaderWriter>(RecordReaderWriter.class);
        ruCompatMap.put(RecordReaderWriter.SIMPLE_DATA_RECORD_READER_WRITER, RecordReaderWriter.DATA_RECORD_READER_WRITER);
        ruCompatMap.put(RecordReaderWriter.SIMPLE_DATA_RECORD_WITH_LFU_EVICTION_READER_WRITER, RecordReaderWriter.DATA_RECORD_READER_WRITER);
        ruCompatMap.put(RecordReaderWriter.SIMPLE_DATA_RECORD_WITH_LRU_EVICTION_READER_WRITER, RecordReaderWriter.DATA_RECORD_READER_WRITER);
        ruCompatMap.put(RecordReaderWriter.DATA_RECORD_READER_WRITER, RecordReaderWriter.DATA_RECORD_READER_WRITER);
        ruCompatMap.put(RecordReaderWriter.DATA_RECORD_WITH_STATS_READER_WRITER, RecordReaderWriter.DATA_RECORD_WITH_STATS_READER_WRITER);
        assert (ruCompatMap.size() == RecordReaderWriter.values().length) : "Missing enum mapping for RU compatibility";
        return ruCompatMap;
    }

    public static void writeRecord(ObjectDataOutput out, Record record, Data dataValue, ExpiryMetadata expiryMetadata) throws IOException {
        RecordReaderWriter readerWriter = record.getMatchingRecordReaderWriter();
        Version version = out.getVersion();
        if (version.isUnknownOrLessThan(Versions.V4_2)) {
            readerWriter = RU_COMPAT_MAP.get((Object)readerWriter);
        }
        out.writeByte(readerWriter.getId());
        readerWriter.writeRecord(out, record, dataValue, expiryMetadata);
    }

    public static Record readRecord(ObjectDataInput in, ExpiryMetadata expiryMetadata) throws IOException {
        byte matchingDataRecordId = in.readByte();
        return RecordReaderWriter.getById(matchingDataRecordId).readRecord(in, expiryMetadata);
    }

    public static Record copyMetadataFrom(Record fromRecord, Record toRecord) {
        toRecord.setHits(fromRecord.getHits());
        toRecord.setVersion(fromRecord.getVersion());
        toRecord.setCreationTime(fromRecord.getCreationTime());
        toRecord.setLastAccessTime(fromRecord.getLastAccessTime());
        toRecord.setLastStoredTime(fromRecord.getLastStoredTime());
        toRecord.setLastUpdateTime(fromRecord.getLastUpdateTime());
        return toRecord;
    }

    public static Object getCachedValue(Record record) {
        Object cachedValue;
        do {
            if ((cachedValue = record.getCachedValueUnsafe()) instanceof Thread) continue;
            return cachedValue;
        } while ((cachedValue = ThreadWrapper.unwrapOrNull(cachedValue)) == null);
        return cachedValue;
    }

    public static Object getValueOrCachedValue(Record record, SerializationService serializationService) {
        Object cachedValue = record.getCachedValueUnsafe();
        if (cachedValue == Record.NOT_CACHED) {
            return record.getValue();
        }
        while (true) {
            if (cachedValue == null) {
                Object valueBeforeCas = record.getValue();
                if (!Records.shouldCache(valueBeforeCas)) {
                    return valueBeforeCas;
                }
                Object fromCache = Records.tryStoreIntoCache(record, valueBeforeCas, serializationService);
                if (fromCache != null) {
                    return fromCache;
                }
            } else if (cachedValue instanceof Thread) {
                if ((cachedValue = ThreadWrapper.unwrapOrNull(cachedValue)) != null) {
                    return cachedValue;
                }
            } else {
                return cachedValue;
            }
            Thread.yield();
            cachedValue = record.getCachedValueUnsafe();
        }
    }

    private static Object tryStoreIntoCache(Record record, Object valueBeforeCas, SerializationService serializationService) {
        Thread currentThread = Thread.currentThread();
        if (!record.casCachedValue(null, currentThread)) {
            return null;
        }
        Object valueAfterCas = record.getValue();
        Object object = null;
        try {
            object = serializationService.toObject(valueBeforeCas);
        }
        catch (Exception e) {
            record.casCachedValue(currentThread, null);
            throw e;
        }
        if (valueAfterCas == valueBeforeCas) {
            Object wrappedObject = ThreadWrapper.wrapIfNeeded(object);
            record.casCachedValue(currentThread, wrappedObject);
        } else {
            record.casCachedValue(currentThread, null);
        }
        return object;
    }

    static boolean shouldCache(Object value) {
        return value instanceof Data && !((Data)value).isPortable() && !((Data)value).isJson();
    }

    private static final class ThreadWrapper
    extends Thread {
        private final Thread wrappedValue;

        private ThreadWrapper(Thread wrappedValue) {
            this.wrappedValue = wrappedValue;
        }

        static Object unwrapOrNull(Object o) {
            if (o instanceof ThreadWrapper) {
                return ((ThreadWrapper)o).wrappedValue;
            }
            return null;
        }

        static Object wrapIfNeeded(Object object) {
            if (object instanceof Thread) {
                return new ThreadWrapper((Thread)object);
            }
            return object;
        }
    }
}

