/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FieldsUtil {
    private static final String METHOD_PREFIX_GET = "get";
    private static final String METHOD_PREFIX_IS = "is";
    private static final String METHOD_GET_FACTORY_ID = "getFactoryId";
    private static final String METHOD_GET_CLASS_ID = "getClassId";

    private FieldsUtil() {
    }

    @Nonnull
    public static SortedMap<String, Class<?>> resolveClass(@Nonnull Class<?> clazz) {
        TreeMap fields = new TreeMap();
        for (Method method : clazz.getMethods()) {
            String attributeName = FieldsUtil.extractAttributeNameFromMethod(clazz, method);
            if (attributeName == null) continue;
            fields.putIfAbsent(attributeName, method.getReturnType());
        }
        for (Class<?> currentClass = clazz; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                fields.putIfAbsent(field.getName(), field.getType());
            }
        }
        return fields;
    }

    @Nullable
    private static String extractAttributeNameFromMethod(@Nonnull Class<?> clazz, @Nonnull Method method) {
        String fieldNameWithWrongCase;
        if (FieldsUtil.skipMethod(clazz, method)) {
            return null;
        }
        String methodName = method.getName();
        if (methodName.startsWith(METHOD_PREFIX_GET) && methodName.length() > METHOD_PREFIX_GET.length()) {
            fieldNameWithWrongCase = methodName.substring(METHOD_PREFIX_GET.length());
        } else if (methodName.startsWith(METHOD_PREFIX_IS) && methodName.length() > METHOD_PREFIX_IS.length()) {
            if (method.getReturnType() != Boolean.TYPE) {
                return null;
            }
            fieldNameWithWrongCase = methodName.substring(METHOD_PREFIX_IS.length());
        } else {
            return null;
        }
        return Character.toLowerCase(fieldNameWithWrongCase.charAt(0)) + fieldNameWithWrongCase.substring(1);
    }

    private static boolean skipMethod(@Nonnull Class<?> clazz, @Nonnull Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return true;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return true;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return true;
        }
        if (method.getParameterCount() != 0) {
            return true;
        }
        if (method.getDeclaringClass() == Object.class) {
            return true;
        }
        String methodName = method.getName();
        return !(!methodName.equals(METHOD_GET_FACTORY_ID) && !methodName.equals(METHOD_GET_CLASS_ID) || !IdentifiedDataSerializable.class.isAssignableFrom(clazz) && !Portable.class.isAssignableFrom(clazz));
    }

    @Nonnull
    public static SortedMap<String, QueryDataType> resolvePortable(@Nonnull ClassDefinition clazz) {
        TreeMap<String, QueryDataType> fields = new TreeMap<String, QueryDataType>();
        for (String name : clazz.getFieldNames()) {
            FieldType portableType = clazz.getFieldType(name);
            QueryDataType type = FieldsUtil.resolvePortableType(portableType);
            fields.putIfAbsent(name, type);
        }
        return fields;
    }

    @Nonnull
    private static QueryDataType resolvePortableType(@Nonnull FieldType portableType) {
        switch (portableType) {
            case BOOLEAN: {
                return QueryDataType.BOOLEAN;
            }
            case BYTE: {
                return QueryDataType.TINYINT;
            }
            case SHORT: {
                return QueryDataType.SMALLINT;
            }
            case CHAR: {
                return QueryDataType.VARCHAR_CHARACTER;
            }
            case UTF: {
                return QueryDataType.VARCHAR;
            }
            case INT: {
                return QueryDataType.INT;
            }
            case LONG: {
                return QueryDataType.BIGINT;
            }
            case FLOAT: {
                return QueryDataType.REAL;
            }
            case DOUBLE: {
                return QueryDataType.DOUBLE;
            }
        }
        return QueryDataType.OBJECT;
    }
}

