/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import java.io.IOException;
import java.util.Objects;

public final class ConstantExpression<T>
implements Expression<T>,
IdentifiedDataSerializable {
    private QueryDataType type;
    private T value;

    public ConstantExpression() {
    }

    private ConstantExpression(T value, QueryDataType type) {
        this.type = type;
        this.value = value;
    }

    public static ConstantExpression<?> create(Object value, QueryDataType type) {
        if (value == null) {
            return new ConstantExpression<Object>(null, type);
        }
        assert (type.getTypeFamily() != QueryDataTypeFamily.NULL);
        Converter valueConverter = Converters.getConverter(value.getClass());
        Converter typeConverter = type.getConverter();
        value = typeConverter.convertToSelf(valueConverter, value);
        return new ConstantExpression<Object>(value, type);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 24;
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        return this.value;
    }

    @Override
    public QueryDataType getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.value);
        out.writeObject(this.type);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.value = in.readObject();
        this.type = (QueryDataType)in.readObject();
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantExpression that = (ConstantExpression)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
    }

    public String toString() {
        return "ConstantExpression{type=" + this.type + ", value=" + this.value + '}';
    }
}

