/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.schema;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelDistribution;
import com.hazelcast.org.apache.calcite.rel.RelDistributionTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelReferentialConstraint;
import com.hazelcast.org.apache.calcite.schema.Statistic;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import java.util.List;

public class Statistics {
    public static final Statistic UNKNOWN = new Statistic(){

        @Override
        public Double getRowCount() {
            return null;
        }

        @Override
        public boolean isKey(ImmutableBitSet columns) {
            return false;
        }

        @Override
        public List<ImmutableBitSet> getKeys() {
            return ImmutableList.of();
        }

        @Override
        public List<RelReferentialConstraint> getReferentialConstraints() {
            return ImmutableList.of();
        }

        @Override
        public List<RelCollation> getCollations() {
            return ImmutableList.of();
        }

        @Override
        public RelDistribution getDistribution() {
            return RelDistributionTraitDef.INSTANCE.getDefault();
        }
    };

    private Statistics() {
    }

    public static Statistic of(List<RelReferentialConstraint> referentialConstraints) {
        return Statistics.of(null, ImmutableList.of(), referentialConstraints, ImmutableList.of());
    }

    public static Statistic of(double rowCount, List<ImmutableBitSet> keys) {
        return Statistics.of(rowCount, keys, ImmutableList.of(), ImmutableList.of());
    }

    public static Statistic of(double rowCount, List<ImmutableBitSet> keys, List<RelCollation> collations) {
        return Statistics.of(rowCount, keys, ImmutableList.of(), collations);
    }

    public static Statistic of(final Double rowCount, final List<ImmutableBitSet> keys, final List<RelReferentialConstraint> referentialConstraints, final List<RelCollation> collations) {
        return new Statistic(){

            @Override
            public Double getRowCount() {
                return rowCount;
            }

            @Override
            public boolean isKey(ImmutableBitSet columns) {
                for (ImmutableBitSet key : keys) {
                    if (!columns.contains(key)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public List<ImmutableBitSet> getKeys() {
                return ImmutableList.copyOf(keys);
            }

            @Override
            public List<RelReferentialConstraint> getReferentialConstraints() {
                return referentialConstraints;
            }

            @Override
            public List<RelCollation> getCollations() {
                return collations;
            }

            @Override
            public RelDistribution getDistribution() {
                return RelDistributionTraitDef.INSTANCE.getDefault();
            }
        };
    }
}

