/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rex;

import com.hazelcast.com.google.common.base.Preconditions;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexBiVisitor;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.org.apache.calcite.rex.RexVisitorImpl;
import com.hazelcast.org.apache.calcite.rex.RexWindow;
import com.hazelcast.org.apache.calcite.sql.SqlAggFunction;
import com.hazelcast.org.apache.calcite.util.ControlFlowException;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RexOver
extends RexCall {
    private static final Finder FINDER = new Finder();
    private final RexWindow window;
    private final boolean distinct;
    private final boolean ignoreNulls;

    RexOver(RelDataType type, SqlAggFunction op, List<RexNode> operands, RexWindow window, boolean distinct, boolean ignoreNulls) {
        super(type, op, operands);
        Preconditions.checkArgument(op.isAggregator());
        this.window = Objects.requireNonNull(window);
        this.distinct = distinct;
        this.ignoreNulls = ignoreNulls;
    }

    public SqlAggFunction getAggOperator() {
        return (SqlAggFunction)this.getOperator();
    }

    public RexWindow getWindow() {
        return this.window;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    @Nonnull
    protected String computeDigest(boolean withType) {
        StringBuilder sb = new StringBuilder(this.op.getName());
        sb.append("(");
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        this.appendOperands(sb);
        sb.append(")");
        if (this.ignoreNulls) {
            sb.append(" IGNORE NULLS");
        }
        if (withType) {
            sb.append(":");
            sb.append(this.type.getFullTypeString());
        }
        sb.append(" OVER (");
        this.window.appendDigest(sb, this.op.allowsFraming()).append(")");
        return sb.toString();
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitOver(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitOver(this, arg);
    }

    @Override
    public int nodeCount() {
        return super.nodeCount() + this.window.nodeCount;
    }

    public static boolean containsOver(RexNode expr) {
        try {
            expr.accept(FINDER);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsOver(RexProgram program) {
        try {
            RexUtil.apply((RexVisitor<Void>)FINDER, program.getExprList(), null);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsOver(List<? extends RexNode> exprs, RexNode condition) {
        try {
            RexUtil.apply((RexVisitor<Void>)FINDER, exprs, condition);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    @Override
    public RexCall clone(RelDataType type, List<RexNode> operands) {
        throw new UnsupportedOperationException();
    }

    private static class Finder
    extends RexVisitorImpl<Void> {
        Finder() {
            super(true);
        }

        @Override
        public Void visitOver(RexOver over) {
            throw OverFound.INSTANCE;
        }
    }

    private static class OverFound
    extends ControlFlowException {
        public static final OverFound INSTANCE = new OverFound();

        private OverFound() {
        }
    }
}

