/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.BiConsumer;

public final class ConfigUtils {
    private static final ILogger LOGGER = Logger.getLogger(Config.class);
    private static final BiConsumer<NamedConfig, String> DEFAULT_NAME_SETTER = NamedConfig::setName;

    private ConfigUtils() {
    }

    public static <T> T lookupByPattern(ConfigPatternMatcher configPatternMatcher, Map<String, T> configPatterns, String itemName) {
        T candidate = configPatterns.get(itemName);
        if (candidate != null) {
            return candidate;
        }
        String configPatternKey = configPatternMatcher.matches(configPatterns.keySet(), itemName);
        if (configPatternKey != null) {
            return configPatterns.get(configPatternKey);
        }
        if (!"default".equals(itemName) && !itemName.startsWith("hz:")) {
            LOGGER.finest("No configuration found for " + itemName + ", using default config!");
        }
        return null;
    }

    public static <T extends NamedConfig> T getConfig(ConfigPatternMatcher configPatternMatcher, Map<String, T> configs, String name, Class clazz) {
        return (T)ConfigUtils.getConfig(configPatternMatcher, configs, name, clazz, DEFAULT_NAME_SETTER);
    }

    public static <T> T getConfig(ConfigPatternMatcher configPatternMatcher, Map<String, T> configs, String name, Class clazz, BiConsumer<T, String> nameSetter) {
        T config = ConfigUtils.lookupByPattern(configPatternMatcher, configs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return config;
        }
        T defConfig = configs.get("default");
        try {
            if (defConfig == null) {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                defConfig = constructor.newInstance(new Object[0]);
                nameSetter.accept(defConfig, "default");
                configs.put("default", defConfig);
            }
            Constructor copyConstructor = clazz.getDeclaredConstructor(clazz);
            copyConstructor.setAccessible(true);
            config = copyConstructor.newInstance(defConfig);
            nameSetter.accept(config, name);
            configs.put(name, config);
            return config;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.severe("Could not create class " + clazz.getName());
            assert (false);
            return null;
        }
    }

    public static InvalidConfigurationException createAmbiguousConfigurationException(String itemName, String candidate, String duplicate) {
        return new InvalidConfigurationException(String.format("Found ambiguous configurations for item\"%s\": \"%s\" vs. \"%s\"%nPlease specify your configuration.", itemName, candidate, duplicate));
    }

    public static boolean matches(String configName, String configName2) {
        return configName != null && configName2 != null && configName.replace("-", "").equals(configName2.replace("-", ""));
    }
}

