/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.local;

import com.hazelcast.hibernate.local.LocalRegionCache;
import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class CleanupService {
    private final Duration fixedDelay;
    private final String name;
    private final ScheduledExecutorService executor;
    private final List<LocalRegionCache> localRegionCaches;

    public CleanupService(String name, Duration fixedDelay) {
        this.fixedDelay = fixedDelay;
        this.name = name;
        this.executor = Executors.newSingleThreadScheduledExecutor(new CleanupThreadFactory());
        this.localRegionCaches = new ArrayList<LocalRegionCache>();
    }

    public void registerCache(LocalRegionCache cache) {
        this.executor.scheduleWithFixedDelay(cache::cleanup, this.fixedDelay.toMillis(), this.fixedDelay.toMillis(), TimeUnit.MILLISECONDS);
        this.localRegionCaches.add(cache);
    }

    public void stop() {
        this.executor.shutdownNow();
        this.localRegionCaches.forEach(LocalRegionCache::destroy);
    }

    private class CleanupThreadFactory
    implements ThreadFactory {
        private CleanupThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(() -> {
                try {
                    r.run();
                }
                catch (OutOfMemoryError e) {
                    OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                }
            }, CleanupService.this.name + ".hibernate.cleanup");
            thread.setDaemon(true);
            return thread;
        }
    }
}

